/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>       Purpose: Contains scan fields, error checking      <<<<
   >>>>                macros, and #defines for UIS line parser  <<<<
   >>>>                                                          <<<<
   >>>>    Written by: Danielle Argiro, Stephanie Hallett        <<<<
   >>>>                Ron E. Neher                              <<<<
   >>>>                                                          <<<<
   >>>>          Date: Jul 16, 1992                              <<<<
   >>>> Modifications: Converted from Khoros 1.0 (DA)            <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kforms_parser_h_
#define _kforms_parser_h_


        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

#define KUIS_ACT 	    1L << 1
#define KUIS_SEL 	    1L << 2
#define KUIS_OPT 	    1L << 3
#define KUIS_LIVE           1L << 4
#define KUIS_POS            1L << 5
#define KUIS_FILECHECK      1L << 6
#define KUIS_ANS            1L << 7
#define KUIS_LOGICALVAL     1L << 8
#define KUIS_LOGICALDEF     1L << 9
#define KUIS_CYCLEVAL       1L << 10
#define KUIS_LISTVAL        1L << 11
#define KUIS_EXECTYPE       1L << 12
#define KUIS_INFILEDEF      1L << 13
#define KUIS_FLG            1L << 14
#define KUIS_MECH           1L << 15
#define KUIS_PREC           1L << 16


        /*-------------------------------------*
        |       static variable declarations
        ---------------------------------------*/

/*
 *  parsing scan fields
 */

static char 

/* -F # @ % gs ps 'l' FormInfoName */
*startform_scan="-%c%d.%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%s",

/* -S @ mutually_exclusive */
*startmaster_scan= "-%c%d%d",

/* -M @ % gs ps 'l' SubformInfoName */
*startsubform_scan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%s",   

/* -D @ % gs 'l' SubMenuInfoName */
*startsubmenu_scan= "-%c%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%s",   

/* -d @ % gs 'l' SubformInfoName */
*subformbutton_scan= "-%c%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%s",   

/* -n @ % gs 'l' 'des' v */
*master_action_scan = "-%c%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/* -P @ % gs ps 'l' PaneInfoName*/
*startpane_scan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%s", 

/*  -G @ gs ps 'l'*/
*startguide_scan= "-%c%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*[']%[^']", 

/* -g @ % gs 'l' PaneInfoName */
*guidebutton_scan= "-%c%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%s",   

/* -Q @ % gs 'l'*/
*quitform_scan= "-%c%d%d%fx%f+%f+%f%*[ ]%*[']%[^']",

/* -m @ % gs 'l' 'des' v */
*subform_action_scan = "-%c%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/*  -H @ gs ps 'l' 'des' help_path var */
*help_scan= "-%c%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%s", 

/* -I @ % * ! ? # gs 'def' 'l' 'des' v 'val' 'literal value' */
*input_scan= "-%c%d%d%d%d%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']",

/* -O @ % * ! ? # gs 'def' 'l' 'des' v 'val' 'literal value' */
*output_scan= "-%c%d%d%d%d%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']",

/* -i @ % * ! ? gs L U def mech incr 'l' 'des' v val 'literal value' */
*int_scan  ="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]%d%d%d%d%d%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%d%*[ ]%*[']%[^']%*[']",

/* -f @ % * ! ? gs L U def prec mech incr 'l' 'des' v val 'literal value' */
*float_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]%f%f%f%d%d%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%f%*[ ]%*[']%[^']%*[']",

/* -h @ % * ! ? gs L U def prec mech incr 'l' 'des' v val 'literal value' */
*double_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]%lg%lg%lg%d%d%lg%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%lg%*[ ]%*[']%[^']%*[']",

/* -l @ % * ! ? gs def 'l' 'label0' 'label1' 'des' v val */
*logic_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]%d%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%d",

/* -t @ % * ! ? gs 'l' 'des' v */
*flag_scan= "-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/* -s @ % * ! ? gs 'def' 'l' 'des' v 'val' 'literal value' */
*string_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[']",

/* -y @ % * ! ? gs num def 'l' 'des' v */
*stringlist_scan="-%c%d%d%d%d%d%fx%f+%f+%f%d%d%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/* -R @ % exec_type gs 'l' 'des' com */
*routine_scan = "-%c%d%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%[^\n]",

/* -T @ % * ! ? gs ps def 'l' 'des' v */
*toggle_scan = "-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s%d",

/* -b ps 'l' v */
*blank_scan = "-%c%*[ ]+%f+%f%*[ ]%*[']%[^']%*[']%s",

/* -e @ * ! ps 'l' v */
*stdin_scan = "-%c%d%d%d%*[ ]+%f+%f%*[ ]%*[']%[^']%*[']%s%*[ ]%*[']%[^']%*[']",

/* -o @ * ! ps 'l' v */
*stdout_scan = "-%c%d%d%d%*[ ]+%f+%f%*[ ]%*[']%[^']%*[']%s%*[ ]%*[']%[^']%*[']",

/* -a @ % gs 'l' 'des' v */
*pane_action_scan = "-%c%d%d%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/* -c @ % * ! ? gs num start def 'l' 'des' v */
*cycle_scan="-%c%d%d%d%d%d%fx%f+%f+%f%d%d%d%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/* -x @ % * ! ? gs num start def 'l' 'des' v */
*list_scan="-%c%d%d%d%d%d%fx%f+%f+%f%d%d%d%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/* -z @ % * ! ? gs num start def dblclick 'l' 'des' v */
*displaylist_scan="-%c%d%d%d%d%d%fx%f+%f+%f%d%d%d%d%*[ ]%*[']%[^']%*[']%*[ ]%*[']%[^']%*[ ']%s",

/* -p filename */
*includepane_scan = "-%c%s",

/* -k filename */
*includesubform_scan = "-%c%s",

/* -w gs 'des' v val */
*workspace_scan = "-%c%fx%f+%f+%f%*[ ]%*[']%[^']%*[']%s%ld";

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/


#define kvf_check_boolean(val)	(((val != 0) && (val != 1))? 0 : 1)
#define kvf_check_opt_sel(val)	(((val != 0) && (val != 1) && (val != 2))? 0 : 1)
#define kvf_check_pos(pos, width) ((pos > width)? 0 : 1)


#endif /* _kforms_parser_h_ */
/* Don't add after this line */
