/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                        <<<<
   >>>>     	Utilities To Print Segments to Generated Files <<<<
   >>>>                                                        <<<<
   >>>>  Private:					       <<<<
   >>>>         kgen_rcs_chdr()			               <<<<
   >>>>         kgen_rcs_hhdr()			               <<<<
   >>>>         kgen_rcs_shhdr()		               <<<<
   >>>>                                                        <<<<
   >>>>         kgen_srcfile_hdr()		               <<<<
   >>>>         kgen_inclfile_hdr()		               <<<<
   >>>>                                                        <<<<
   >>>>         kgen_inclfile_incl_comm()		       <<<<
   >>>>         kgen_inclfile_def_comm()		       <<<<
   >>>>         kgen_inclfile_typedef_comm()		       <<<<
   >>>>         kgen_inclfile_global_comm()		       <<<<
   >>>>         kgen_inclfile_macro_comm()		       <<<<
   >>>>         kgen_inclfile_routine_comm()		       <<<<
   >>>>                                                        <<<<
   >>>>         kgen_pubsrc_hdr()		               <<<<
   >>>>         kgen_privsrc_hdr()		               <<<<
   >>>>   Static:                                              <<<<
   >>>>                                                        <<<<
   >>>>   Public:					       <<<<
   >>>>                                                        <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "gen_strings.h"

/*-----------------------------------------------------------
|
|  Routine Name: kgen_rcs_chdr
|
|       Purpose: Generates the RCS header for *.c files.
|
|         Input: file - open stream to file in which to write RCS header
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 6, 1992
| Modifications:
|
------------------------------------------------------------*/

void
kgen_rcs_chdr(
	kfile		*file)
{
        kfprintf(file, " /*\n  * Khoros: %cId%c\n  */\n\n", '$', '$');
        kfprintf(file, "#if !defined(__lint) && !defined(__CODECENTER__)\n");
        kfprintf(file, "static char rcsid[] = \"Khoros: %cId%c\";\n", '$','$');
        kfprintf(file, "#endif\n\n");
        kfprintf(file, " /*\n  * %cLog%c\n  */\n\n", '$', '$');
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_rcs_hhdr
|
|       Purpose: Generates the RCS header for *.h files.
|
|         Input: file - open stream to file in which to write RCS header
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 6, 1992
| Modifications:
|
------------------------------------------------------------*/

void
kgen_rcs_hhdr(
	kfile		*file)
{
        kfprintf(file, " /*\n  * Khoros: %cId%c\n  */\n\n", '$', '$');
        kfprintf(file, " /*\n  * %cLog%c\n  */\n\n", '$', '$');
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_rcs_shhdr
|
|       Purpose: Generates the RCS header for *.sh files.
|
|         Input: file - open stream to file in which to write RCS header
|        Output: none
|
|    Written By: Danielle Argiro
|          Date: January 17, 1994
| Modifications:
|
------------------------------------------------------------*/

void
kgen_rcs_shhdr(
        kfile           *file)
{
        kfprintf(file, "#\n# Khoros: %cId%c\n#\n\n", '$', '$');
        kfprintf(file, "#\n# %cLog%c\n#\n\n", '$', '$');
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_srcfile_hdr
|
|       Purpose: Generates the file header for source files with
|                more than one routine.
|
|         Input: file - open stream to file in which to write file header
|                title_string  - string describing file contents in general
|                priv_routines - array of private routine names
|                priv_num      - number of private routines
|                stat_routines - array of static routine names
|                stat_num      - number of static routines
|                pub_routines  - array of public routine names
|                pub_num       - number of public routines
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_srcfile_hdr(
	kfile		*file,
	char		*title_string,
	char		**priv_routines,
	int		priv_num,
	char		**stat_routines,
	int		stat_num,
	char		**pub_routines,
	int		pub_num)
{
	int		i;


        kfprintf(file, "%s\n", kfilehdr_begin);
        kfprintf(file, "%s\n", kfilehdr_sep);

	if (title_string != NULL)
	{
            kfprintf(file, "%s\t%s\n", kfilehdr_sep, title_string);
            kfprintf(file, "%s\n", kfilehdr_sep);
	}

        kfprintf(file, "%s\n", kfilehdr_priv);

	for (i = 0; i < priv_num; i++)
	{
	    if (priv_routines[i] != NULL)
                kfprintf(file, "%s\t%s\n", kfilehdr_sep, priv_routines[i]);
	    else
	    {
		errno = KNULL_PARAMETER;
		kerror(KCODEGEN, "kgen_src_hdr", "element %d of priv_routines array cannot be NULL when priv_num is specified as %d", i, priv_num);
            }
	}

        kfprintf(file, "%s\n", kfilehdr_sep);

        kfprintf(file, "%s\n", kfilehdr_stat);

	for (i = 0; i < stat_num; i++)
	{
	    if (stat_routines[i] != NULL)
                kfprintf(file, "%s\t%s\n", kfilehdr_sep, stat_routines[i]);
	    else
	    {
		errno = KNULL_PARAMETER;
		kerror(KCODEGEN, "kgen_src_hdr", "element %d of stat_routines array cannot be NULL when stat_num is specified as %d", i, stat_num);
	    }
	}

        kfprintf(file, "%s\n", kfilehdr_pub);

	for (i = 0; i < pub_num; i++)
	{
	    if (pub_routines[i] != NULL)
                kfprintf(file, "%s\t%s\n", kfilehdr_sep, pub_routines[i]);
	    else
	    {
		errno = KNULL_PARAMETER;
		kerror(KCODEGEN, "kgen_src_hdr", "element %d of pub_routines array cannot be NULL when pub_num is specified as %d", i, pub_num);
	    }
	}

        kfprintf(file, "%s\n", kfilehdr_sep);
        kfprintf(file, "%s\n\n\n", kfilehdr_end);
}


/*-----------------------------------------------------------
|
|  Routine Name: kgen_inclfile_hdr
|
|       Purpose: Generates the file header for include files
|
|         Input: file     - open stream to file in which to write file header
|                purpose  - string describing purpose of include file
|                author   - string naming authors of include file
|                mods     - string describing modifications to include file
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_inclfile_hdr(
	kfile		*file,
	char		*purpose,
	char		*author,
	char		*mods)
{
	char		date[KLENGTH];
	struct tm	*localclock;
	time_t		clck;


	kfprintf(file, "%s\n", kfilehdr_begin);
	kfprintf(file, "%s\n", kfilehdr_sep);

	if (purpose != NULL)
	    kfprintf(file, "%s%s\n", kfilehdr_purp, purpose);
	else kfprintf(file, "%s\n", kfilehdr_purp);

	kfprintf(file, "%s\n", kfilehdr_sep);

	if (author != NULL)
	    kfprintf(file, "%s%s\n", kfilehdr_auth, author);
	else kfprintf(file, "%s\n", kfilehdr_auth);

	kfprintf(file, "%s\n", kfilehdr_sep);

	if (mods != NULL)
	    kfprintf(file, "%s%s\n", kfilehdr_mods, mods);
	else kfprintf(file, "%s\n", kfilehdr_mods);

	kfprintf(file, "%s\n", kfilehdr_sep);

	clck = (time_t) time(NULL);
	localclock = (struct tm *) localtime((const time_t *) &clck);
	strftime(date, KLENGTH, "%h %d, %Y", localclock);
	kfprintf(file, "%s%s\n", kfilehdr_date, date);

	kfprintf(file, "%s\n", kfilehdr_sep);
	kfprintf(file, "%s\n\n\n", kfilehdr_end);

}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_inclfile_incl_comm
|
|       Purpose: Generates the standardized comment for
|                #includes inside include files
|
|         Input: file - open stream to file in which to write comment
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_inclfile_incl_comm(
	kfile		*file)
{
	kfprintf(file, "%s\n%s\n%s\n\n", kinclfile_comm_begin, 
                kinclfile_comm_include, kinclfile_comm_end);
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_inclfile_def_comm
|
|       Purpose: Generates the standardized comment for
|                #defines inside include files
|
|         Input: file - open stream to file in which to write comment
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_inclfile_def_comm(
	kfile		*file)
{
	kfprintf(file, "%s\n%s\n%s\n\n", kinclfile_comm_begin, 
                kinclfile_comm_defines, kinclfile_comm_end);
}


/*-----------------------------------------------------------
|
|  Routine Name: kgen_inclfile_typedef_comm
|
|       Purpose: Generates the standardized comment for
|                typedefs inside include files
|
|         Input: file - open stream to file in which to write comment
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_inclfile_typedef_comm(
	kfile		*file)
{
	kfprintf(file, "%s\n%s\n%s\n\n", kinclfile_comm_begin, 
                kinclfile_comm_typedefs, kinclfile_comm_end);
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_inclfile_global_comm
|
|       Purpose: Generates the standardized comment for
|                globals inside include files
|
|         Input: file - open stream to file in which to write comment
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_inclfile_global_comm(
	kfile		*file)
{
	kfprintf(file, "%s\n%s\n%s\n\n", kinclfile_comm_begin, 
                kinclfile_comm_globals, kinclfile_comm_end);
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_inclfile_macro_comm
|
|       Purpose: Generates the standardized comment for
|                macros inside include files
|
|         Input: file - open stream to file in which to write comment
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_inclfile_macro_comm(
	kfile		*file)
{
	kfprintf(file, "%s\n%s\n%s\n\n", kinclfile_comm_begin, 
                kinclfile_comm_macros, kinclfile_comm_end);
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_inclfile_routine_comm
|
|       Purpose: Generates the standardized comment for
|                routine definitions inside include files
|
|         Input: file - open stream to file in which to write comment
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 7, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_inclfile_routine_comm(
	kfile		*file)
{
	kfprintf(file, "%s\n%s\n%s\n\n", kinclfile_comm_begin, 
                kinclfile_comm_defs, kinclfile_comm_end);
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_pubsrc_hdr
|
|       Purpose: Generates the header for (public) source code.
|
|         Input: file    - open stream to file in which to write RCS header
|                name    - name of routine 
|                purpose - purpose of routine 
|                input   - input to routine
|                output  - output from routine
|                restr   - restrictions on routine
|                author  - author of routine
|                verif   - verified by
|                side    - side effects
|                mods    - modifications
|               
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 6, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_pubsrc_hdr(
	kfile		*file,
	char		*name,
	char		*purpose,
	char		*input,
	char		*output,
	char		*returns,
	char		*restr,
	char		*author,
	char		*verif,
	char		*side,
	char		*mods)
{
	char		date[KLENGTH];
	time_t		clck;
	struct tm	*localclock;


	kfprintf(file, "%s\n",   kpubsrc_hdr_begin);
	kfprintf(file, "%s\n",   kpubsrc_hdr_sep);

	if (name != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_name, name);
	else kfprintf(file, "%s\n", kpubsrc_hdr_name);

	kfprintf(file, "%s\n",   kpubsrc_hdr_sep);

	if (purpose != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_purp, purpose);
	else kfprintf(file, "%s\n", kpubsrc_hdr_purp);

	if (input != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_in, input);
	else kfprintf(file, "%s\n", kpubsrc_hdr_in);

	if (output != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_out, output);
	else kfprintf(file, "%s\n", kpubsrc_hdr_out);

	if (returns != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_ret, returns);
	else kfprintf(file, "%s\n", kpubsrc_hdr_ret);

	if (restr != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_rest, restr);
	else kfprintf(file, "%s\n", kpubsrc_hdr_rest);

	if (author != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_auth, author);
	else kfprintf(file, "%s\n", kpubsrc_hdr_auth);

	clck = (time_t) time(NULL);
	localclock = (struct tm *) localtime((const time_t *) &clck);
	strftime(date, KLENGTH, "%h %d, %Y", localclock);
	kfprintf(file, "%s%s\n", kpubsrc_hdr_date, date);

	if (verif != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_ver, verif);
	else kfprintf(file, "%s\n", kpubsrc_hdr_ver);

	if (side != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_side, side);
	else kfprintf(file, "%s\n", kpubsrc_hdr_side);

	if (mods != NULL)
	    kfprintf(file, "%s%s\n", kpubsrc_hdr_mods, mods);
	else kfprintf(file, "%s\n", kpubsrc_hdr_mods);

	kfprintf(file, "%s\n",   kpubsrc_hdr_end);
}

/*-----------------------------------------------------------
|
|  Routine Name: kgen_privsrc_hdr
|
|       Purpose: Generates the header for (private) source code.
|
|         Input: file    - open stream to file in which to write RCS header
|                name    - name of routine 
|                purpose - purpose of routine 
|                input   - input to routine
|                output  - output from routine
|                author  - author of routine
|                mods    - modifications
|               
|        Output: none
|
|    Written By: Danielle Argiro 
|          Date: July 6, 1992
| Modifications:
|
------------------------------------------------------------*/
void
kgen_privsrc_hdr(
	kfile		*file,
	char		*name,
	char		*purpose,
	char		*input,
	char		*output,
	char		*author,
	char		*mods)

{
	char		date[KLENGTH];
	time_t		clck;
	struct tm	*localclock;


	kfprintf(file, "%s\n",   kprivsrc_hdr_begin);
	kfprintf(file, "%s\n",   kprivsrc_hdr_sep);

	if (name != NULL)
	    kfprintf(file, "%s%s\n", kprivsrc_hdr_name, name);
	else kfprintf(file, "%s\n", kprivsrc_hdr_name);

	kfprintf(file, "%s\n",   kprivsrc_hdr_sep);

	if (purpose != NULL)
	    kfprintf(file, "%s%s\n", kprivsrc_hdr_purp, purpose);
	else kfprintf(file, "%s\n", kprivsrc_hdr_purp);

	kfprintf(file, "%s\n",   kprivsrc_hdr_sep);

	if (input != NULL)
	    kfprintf(file, "%s%s\n", kprivsrc_hdr_in, input);
	else kfprintf(file, "%s\n", kprivsrc_hdr_in);

	kfprintf(file, "%s\n",   kprivsrc_hdr_sep);

	if (output != NULL)
	    kfprintf(file, "%s%s\n", kprivsrc_hdr_out, output);
	else kfprintf(file, "%s\n", kprivsrc_hdr_out);

	if (author != NULL)
	    kfprintf(file, "%s%s\n", kprivsrc_hdr_auth, author);
	else kfprintf(file, "%s\n", kprivsrc_hdr_auth);

	clck = (time_t) time(NULL);
	localclock = (struct tm *) localtime((const time_t *) &clck);
	strftime(date, KLENGTH, "%h %d, %Y", localclock);
	kfprintf(file, "%s%s\n", kprivsrc_hdr_date, date);

	if (mods != NULL)
	    kfprintf(file, "%s%s\n", kprivsrc_hdr_mods, mods);
	else kfprintf(file, "%s\n", kprivsrc_hdr_mods);

	kfprintf(file, "%s\n",   kprivsrc_hdr_sep);
	kfprintf(file, "%s\n",   kprivsrc_hdr_end);
}


/*-----------------------------------------------------------
|
|  Routine Name: kgen_scriptsrc_hdr
|
|       Purpose: Generates the header for shell script.
|
|         Input: file    - open stream to file in which to write header
|                name    - name of routine
|                purpose - purpose of routine
|                author  - author of routine
|
|        Output: none
|
|    Written By: Danielle Argiro
|          Date: January 17, 1994
| Modifications:
|
------------------------------------------------------------*/
void
kgen_scriptsrc_hdr(
        kfile           *file,
        char            *name,
        char            *purpose,
        char            *author,
	char            *rest,
	char            *mods)
{
	char		date[KLENGTH];
	time_t		clck;
	struct tm	*localclock;


	kfprintf(file, "%s\n",   kshsrc_hdr_begin);
	kfprintf(file, "%s\n",   kshsrc_hdr_sep);

	if (name != NULL)
	    kfprintf(file, "%s%s\n", kshsrc_hdr_name, name);
	else kfprintf(file, "%s\n", kshsrc_hdr_name);

	kfprintf(file, "%s\n",   kshsrc_hdr_sep);

	if (purpose != NULL)
	    kfprintf(file, "%s%s\n", kshsrc_hdr_purp, purpose);
	else kfprintf(file, "%s\n", kshsrc_hdr_purp);

	if (author != NULL)
	    kfprintf(file, "%s%s\n", kshsrc_hdr_auth, author);
	else kfprintf(file, "%s\n", kshsrc_hdr_auth);

	clck = (time_t) time(NULL);
	localclock = (struct tm *) localtime((const time_t *) &clck);
	strftime(date, KLENGTH, "%h %d, %Y", localclock);
	kfprintf(file, "%s%s\n", kshsrc_hdr_date, date);

        if (rest != NULL)
            kfprintf(file, "%s%s\n", kshsrc_hdr_rest, rest);
        else kfprintf(file, "%s\n", kshsrc_hdr_rest);

        if (mods != NULL)
            kfprintf(file, "%s%s\n", kshsrc_hdr_mods, mods);
        else kfprintf(file, "%s\n", kshsrc_hdr_mods);

	kfprintf(file, "%s\n",   kshsrc_hdr_sep);
	kfprintf(file, "%s\n\n\n",   kshsrc_hdr_end);
}


