/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>               General Utilities 		      <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>           kgen_open_file()                            <<<<
   >>>>           kgen_selection_codegen_warranted()          <<<<
   >>>>           kgen_subform_codegen_warranted()            <<<<
   >>>>           kgen_valid_selections()                     <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"  

/*------------------------------------------------------------
|
|  Routine Name: kgen_open_file
|
|       Purpose: This routine creates & opens a file with the program_name
|		 given, returns open stream to that file.
|
|         Input: object   - The software object which the file is associated
|			    with.
|		 filename - program_name of file to be opened.  
|
|        Output: Returns open stream to file on success, NULL on failure.
|                user_refused - TRUE if user responded "N" to over-write,
|                               FALSE if user responded "Y" to over-write,
|                                   but file could not be opened.
|    Written By: Danielle Argiro
|          Date: Jul 22, 1992 18:56
| Modifications:
|
------------------------------------------------------------*/

kfile *kgen_open_file(
   kobject  object,
   char    *filename,
   int     *user_refused)
{
	int            force_flag   = FALSE;
	kobject        fobj         = NULL;
	kstring        opath;
        char           fullpath[KLENGTH];
        kfile         *file; 
	unsigned long  update_flag;


        *user_refused = FALSE;
	if (!kcms_get_attributes(object,
				 KCMS_PATH,            &opath,
				 KCMS_END)
	    || !kcms_query_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE,
			       &force_flag))
	   return NULL;

	ksprintf(fullpath, "%s/src/%s", opath, filename);

	if (!kcms_get_attribute(object, KCMS_CMOBJ_UPDATE_DB, &update_flag))
	    update_flag = KCMS_UPDATE_NONE;
	
        /*
         *  first of all, if 'form_info.h' exists, see if they want to
	 *  overwrite it.  If not, return immediately.
         */
        if (!force_flag && (update_flag & KCMS_UPDATE_NEW) != KCMS_UPDATE_NEW)
        {
	    if (!(koverwrite(kget_notify(), filename)))
	    {
	       *user_refused = TRUE;
               return(NULL);
	    }
        }

	if (kaccess(fullpath, F_OK) != 0)
	{
	    /*
	     * the '-1's in the call below tell kcms_create_fileobj to
	     * take its best guess to the type and subtype.
	     */
	    fobj = kcms_create_fileobj(object, fullpath, NULL,
				       KCMS_FOBJ_TYPE_SRC,
				       KCMS_FOBJ_SUBTYPE_C, 
				       KCMS_FOBJ_GEN_COND,
				       KCMS_FOBJ_ACCESS_RDWR);

	    if (fobj == NULL) return(NULL);

#if 0
	    /*-- doesn't seem to be needed --*/
	    kgen_newfile = TRUE;
#endif
	}
        
        /*
         * create & open the file
         */
        if ((file = kfopen(fullpath, "w"))== NULL)
        {
	     kerror(KCODEGEN, "conductor",
             	    "Could not create file '%s'\n", filename);
             return(NULL);
        }
        return(file);
}

/*------------------------------------------------------------
|
|  Routine Name: kgen_selection_codegen_warranted
|
|       Purpose: This routine checks a selection list for
|                action buttons & "live" selections, that would
|                require a "do" routine and a call to the "do" routine
|                in form_drv.c. This is so we can avoid generating 
|                empty routines.
|
|         Input: sel_list - header of selection list
|        Output: none 
|       Returns: TRUE if there are actions/live selections, FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Oct 1, 1993
| Modifications:
|
------------------------------------------------------------*/

int kgen_selection_codegen_warranted(
   kselection *sel_list)
{
	kselection *selection;
	int        flag, live, found = FALSE;

	selection = sel_list;
	while ((selection != NULL) && (!found))
	{
	    flag = selection->type;
	    if ((flag == KUIS_PANEACTION)    ||
	        (flag == KUIS_SUBFORMACTION) ||
		(flag == KUIS_MASTERACTION))
		found = TRUE;
	    else if ((flag != KUIS_QUIT) &&
		     (flag != KUIS_HELP) &&
		     (flag != KUIS_BLANK) &&
		     (flag != KUIS_STDIN) &&
		     (flag != KUIS_STDOUT) &&
		     (flag != KUIS_STARTSUBMENU) &&
		     (flag != KUIS_ROUTINE) &&
		     (flag != KUIS_MUTEXCL) &&
		     (flag != KUIS_MUTINCL) &&
		     (flag != KUIS_GROUP) &&
		     (flag != KUIS_WORKSPACE))
	    {
	        kvf_get_attribute(selection->back_kformstruct,
			          KVF_LIVE, &live);
		if (live) found = TRUE;
	    }
	    else if ((flag != KUIS_MUTEXCL) ||
                     (flag != KUIS_MUTINCL) ||
                     (flag != KUIS_GROUP))
	    {
		if (kgen_selection_codegen_warranted(selection->group_next))
		    return(TRUE);
	    }
	    selection = selection->next;
	}
	return(found);
}



/*------------------------------------------------------------
|
|  Routine Name: kgen_subform_codegen_warranted
|
|       Purpose: This routine checks a subform for
|                action buttons & "live" selections, that would
|                require a "do" routine and a call to the "do" routine
|                in form_drv.c.  This is so we can avoid
|                This is so we can avoid generating empty routines.
|
|         Input: subform - pointer to subform 
|        Output: none
|       Returns: TRUE if there are actions/live selections, FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Oct 1, 1993
| Modifications:
|
------------------------------------------------------------*/
int kgen_subform_codegen_warranted(
    ksubform *subform)
{
	kguide *guide;

	if (subform->guidepane != NULL)
	{
	    guide = subform->guidepane->guide_list;
	    if (kgen_selection_codegen_warranted(subform->guidepane->sel_list))
		return(TRUE);
	}
	else guide = subform->guide;

	while (guide != NULL)
	{
	    if (guide->pane != NULL) 
	    {
		if (kgen_selection_codegen_warranted(guide->pane->sel_list))
		    return(TRUE);
	    }
	    guide = guide->next;
	}
	return(FALSE);
}

/*------------------------------------------------------------
|
|  Routine Name: kgen_valid_selections
|
|       Purpose: This routine checks a selection list for
|                all valid selections that would require a structure
|                => in the form_info.h file.
|
|                and needless functions when there are no selections
|                that need it.
|
|         Input: sel_list - header of selection list
|        Output: none 
|       Returns: TRUE if there are actions/live selections, FALSE otherwise
|    Written By: Danielle Argiro
|          Date: Oct 1, 1993
| Modifications:
|
------------------------------------------------------------*/

int kgen_valid_selections(
   kselection *sel_list)
{
	kselection *selection;
	int        found = FALSE;

	selection = sel_list;
	while ((selection != NULL) && (!found))
	{
	    switch (selection->type)
	    {
		case KUIS_MASTERACTION:
		case KUIS_SUBFORMACTION:
		case KUIS_PANEACTION:
		case KUIS_INPUTFILE:
		case KUIS_OUTPUTFILE:
		case KUIS_INTEGER:
		case KUIS_FLOAT:
		case KUIS_STRING:
		case KUIS_LOGICAL:
		case KUIS_CYCLE:
		case KUIS_LIST:
		case KUIS_TOGGLE:
		case KUIS_FLAG:
		case KUIS_STRINGLIST:
		case KUIS_DOUBLE:
		case KUIS_DISPLAYLIST:
		case KUIS_BLANK:
		case KUIS_STDIN:
		case KUIS_STDOUT:
		case KUIS_HELP:
		case KUIS_QUIT:
		case KUIS_WORKSPACE:
		     found = TRUE;
		     break;

		case KUIS_MUTEXCL:
		case KUIS_MUTINCL:
		case KUIS_GROUP:
		     if (kgen_valid_selections(selection->group_next))
			return(TRUE);
		     break;

		default:
		     break;
	    }

	    if (found) return(TRUE);
	    selection = selection->next;
	}
	return(FALSE);
}
