/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>              Routines to Generate library headers     <<<<
   >>>>                                                       <<<<
   >>>>   Static:                                             <<<<
   >>>>  Private:                                             <<<<
   >>>>                kgen_clui_generate_library()           <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*---------------------------------------------------------------
|
|  Routine Name: kgen_clui_generate_library
|
|       Purpose: Creates a library object 
|
|         Input: library   -  pointer to the library object
|
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: Danielle Argiro & Steve Jorgensen
|          Date: Jan 14, 1993 14:58
| Modifications:
|
--------------------------------------------------------------*/

int kgen_clui_generate_library(
   kobject library)
{
	header_info *header;
	char *path, *oname, install_path[KLENGTH];
	kstring  routine = "kgen_clui_generate_library()";

	if (!kcms_get_attributes(library,
				KCMS_PATH, &path,
				KCMS_NAME, &oname,
				KCMS_END))
	    return(FALSE);

	ksprintf(install_path,"%s/man", path);
        if (kmkdir(install_path, 0777) != 0 && errno != EEXIST)
        {
           kerror(KCODEGEN, NULL, "Cannot create install directory '%s'\n",
                   install_path);
           return(FALSE);
        }

	while (kcms_get_attribute(library, KCMS_CMOBJ_HEADERINFO,
			&header) != FALSE)
	{
	    if (!kgen_generate_manpage(library, header, install_path))
	    {
	       kannounce(KCODEGEN, routine,
		     "An Error occurred while installing the "
		     "man page for '%s' in '%s/%s'.  "
		     "Continuing with the next man page.\n",
		     header->name, install_path, header->name);
	    }
	    else
	    {
	       kannounce(KCODEGEN, routine,
		     "Finished Generating a man page for the "
		     "function '%s' in '%s/%s'\n",
		     header->name, install_path, header->name);
	    }
	}
	kannounce(KCODEGEN, routine ,"done generating %s library headers",
			oname);
	kinfo(KHOSTILE,"the headers for your %s library really suck.", oname);
	return(TRUE);
}
