/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>    Generate Manpage and Whatis for a Software Object
   >>>>
   >>>>   Static:
   >>>>             _kgen_insert_lp()
   >>>>  Private:
   >>>>   Public:
   >>>>             kgen_generate_whatis()
   >>>>             kgen_generate_manpage()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

#define WHATISFILE "repos/config/whatis"

/*-----------------------------------------------------------
|  Routine Name: _kgen_insert_lp - insert .LP into a text block
|
|       Purpose: This routine looks for a blank lines in the text
|		 block, and replaces them with a .LP line.
|
|         Input: file   - an open kfile pointer
|		 string - the text block to fix
|        Output:
|       Returns:
|
|    Written By: Steven Jorgensen
|          Date: Dec 10, 1992 05:09
------------------------------------------------------------*/
static void 
_kgen_insert_lp(
	kfile		*file,
	char		*string)
{
	char		*new, *tmp;
	int		status;


	if (string == NULL)
	{
		kfprintf(file, "none\n");
		return;
	}

	new = kstring_replace(string, "\n\n", "\n.LP\n", NULL);
	(void) kparse_string_search(new,"\\.LP\n\\.LP",KLITERAL,NULL,&status);
	while (status == KPARSE_OK)
	{
		tmp = kstring_replace(string, ".LP\n.LP", ".LP", NULL);
		kfree(new);
		new = tmp;
		tmp = NULL;
		(void) kparse_string_search(new,"\\.LP\n\\.LP",KLITERAL,NULL,
			&status);
	}
	kfprintf(file, "%s\n", new);
	kfree(new);
}

/************************************************************
*  Routine Name: kgen_generate_whatis - update man directory whatis file
*
*       Purpose: This routine takes a new routine name, its short
*		 description, the library name, and the toolbox name,
*		 and either inserts the item into the toolboxes whatis file,
*		 or updates the current entry in the whatis file.
*
*         Input: routine    - The routine name of the entry to be added to the
*			      whatis file
*		 short_desc - The short description of the routine
*		 lib_name   - The library a routine belongs to.  "1" if the
*			      routine is a program.
*                tb_name    - the toolbox in which we are updating the whatis
*			      file
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Steven Jorgensen
*          Date: Feb 16, 1993 13:16
*************************************************************/
int 
kgen_generate_whatis(
	kobject		object,
	char		*func_name,
	char		*short_desc)
{
	kstring         routine  = "kgen_generate_whatis";
	kobject		toolbox;
	char		key[KLENGTH], path[KLENGTH],
			temp[KLENGTH], tbname[KLENGTH];
	char		paren[KLENGTH];
	char		*lib_name, *tb_name, *data, *new, **array, *sd;
	int		i, array_cnt, status;
	kfile		*file;


	if (!func_name)
	   return (FALSE);

	if (!kcms_get_attributes(object,
				 KCMS_NAME,   &lib_name,
	                         KCMS_PARENT, &toolbox,
				 KCMS_END)
	    || !kcms_get_attribute(toolbox, KCMS_NAME, &tb_name))
		return (FALSE);

	kstring_upper(tb_name, tbname);
	kstrcpy(paren, "()");
	if (kstrcmp(lib_name, "1") == 0)
		paren[0] = '\0';
	sd = (short_desc == NULL) ? "" : short_desc;
	ksprintf(key, "^%s\\(?\\)? \\(%s\\)", func_name, lib_name);
	ksprintf(path, "$%s/%s", tbname, WHATISFILE);
	ksprintf(temp, "%s%s (%s)\t\t-  %s", func_name, paren, lib_name, sd);
	new = kstrdup(temp);
	data = kreadfile(path, NULL);
	array = kparse_string_delimit(data, "\n", KDELIM_CLEAN, &array_cnt);
	(void) kparse_string_search(data, key, KLITERAL, NULL, &status);
	kfree(data);
	if (status == KPARSE_OK)
	{
		ksprintf(temp, "%s%s (%s)", func_name, paren, lib_name);
		for (i = 0; i < array_cnt; i++)
			if (kstrncmp(temp, array[i], kstrlen(temp)) == 0)
				break;
		if (i < array_cnt)
		{
			kfree(array[i]);
			array[i] = new;
		}
		else
		{
			kerror(KCODEGEN, routine,
			       "kparse_string_search says that '%s' is in "
			       "the whatis file, but the entry cannot be "
			       "found in the array.\n", func_name);
			karray_free(array, array_cnt, NULL);
			kfree(new);
			return (FALSE);
		}
	}
	else
	{
		array = karray_add(array, new, array_cnt);
		array_cnt++;
		array = karray_sort(array, array_cnt, FALSE);
	}

	if ((file = kfopen(path, "w")) == NULL)
	{
		kerror(KCODEGEN, routine,
		       "Cannot write to '%s' to update the whatis file.", path);
		karray_free(array, array_cnt, NULL);
		return (FALSE);
	}
	for (i = 0; i < array_cnt; i++)
		kfprintf(file, "%s\n", array[i]);
	kfclose(file);

	karray_free(array, array_cnt, NULL);
	return (TRUE);
}

/************************************************************
*  Routine Name: kgen_generate_manpage - generate a man page
*
*       Purpose: This routine generates a man page given a
*		 header_info structure to work from.
*
*         Input: header   - the header_info to generate a man page from
*		 path     - the place to put the man page
*		 tb_name  - the toolbox name
*		 lib_name - the library name
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*    Written By: Steven Jorgensen
*          Date: Feb 15, 1993 14:46
*************************************************************/
int 
kgen_generate_manpage(
	kobject		object,
	header_info	*header,
	char		*path)
{
	kstring         routine  = "kgen_generate_manpage";
	kobject		toolbox;
	char		*lib_name, *tb_name, *opath;
	char		manpath[KLENGTH], date[KLENGTH];
	time_t		clck;
	struct tm	*localclock;
	kfile		*file;
	kstring         copyright;
	char		*add_begin	= "^.SH ADDITIONAL INFORMATION$";
	char		*add_end1	= "^.SH EXAMPLES$";
	char		*add_end2	= "^.SH SIDE EFFECTS$";
	char		*add_info	= NULL;
	char		*ex_begin	= "^.SH EXAMPLES$";
	char		*ex_end		= "^.SH SIDE EFFECTS$";
	char		*ex_info	= NULL;
	char		*sa_begin	= "^.SH SEE ALSO$";
	char		*sa_end		= "^.SH COPYRIGHT$";
	char		*sa_info	= NULL;
	char		*upper;
	int		i, status;


	clck = time(NULL);
	localclock = localtime((const time_t *) & clck);
	strftime(date, KLENGTH, "%h %d, %Y", localclock);
	if (!kcms_get_attributes(object,
				KCMS_NAME,   &lib_name,
				KCMS_PATH,   &opath,
				KCMS_PARENT, &toolbox,
				KCMS_END)
            || !kcms_get_attribute(toolbox, KCMS_NAME, &tb_name))
	{
		kwarn(KCODEGEN, routine,
		      "Could not get all attributes required,\n"
		      "so man page was not generated.");
		return (FALSE);
	}
	if (path == NULL)
		sprintf(manpath, "%s/man/%s.3", opath, header->name);
	else
		sprintf(manpath, "%s/%s.3", path, header->name);

	copyright = kcms_get_copyright(toolbox, KCMS_TB_COPYRIGHT_SHORT,
						KCMS_LANG_NONE);

	if ((kaccess(manpath, R_OK) == 0) &&
		((file = kfopen(manpath, "r")) != NULL))
	{
		add_info = kparse_file_scan(file, add_begin, add_end1, KIGNORE_CASE,
			NULL, NULL, &status);
		krewind(file);
		if (status == KPARSE_NOEND)
			add_info = kparse_file_scan(file, add_begin, add_end2, KIGNORE_CASE,
				NULL, NULL, &status);
		else
			ex_info = kparse_file_scan(file, ex_begin, ex_end, KIGNORE_CASE,
				NULL, NULL, &status);
		krewind(file);
		sa_info = kparse_file_scan(file, sa_begin, sa_end, KIGNORE_CASE,
			NULL, NULL, &status);
		kfclose(file);
	}

	if ((file = kfopen(manpath, "w")) == NULL)
	{
		kerror(KCODEGEN, "kgen_generate_manpage",
			"Unable to open '%s' for writing\n", manpath);
		kfree(add_info);
		kfree(ex_info);
		kfree(sa_info);
		return (FALSE);
	}

	upper = kstring_upper(tb_name, NULL);
	kfprintf(file, ".TH \"%s\" \"%s\" \"LIBRARY\" \"(%s)\" \"%s\"\n",
		header->name, upper, lib_name, date);
	kfree(upper);
	kfprintf(file, ".nr LL 7.0i\n");
	kfprintf(file, ".SH LIBRARY ROUTINE\n");
	if (header->shortdesc == NULL)
		kfprintf(file, "%s\n", header->name);
	else
		kfprintf(file, "%s - %s\n", header->name, header->shortdesc);

	kfprintf(file, ".SH LIBRARY CALL\n");
	if (header->declaration != NULL)
	{
	    kfprintf(file, ".nf\n");
	    kfprintf(file, "%s\n", header->declaration);
	    kfprintf(file, ".fi\n");
	}
	else
	{
	    kwarn("kcodegen", routine,
		  "Declaration for routine %s is missing!\n"
		  "Please check header of macro, it must include the "
		  "'Declaration:' field", header->name);
	}

	kfprintf(file, ".SH INPUT\n");
	if (header->in_cnt <= 0)
	{
		kfprintf(file, ".LP\n");
		kfprintf(file, "none\n");
	}
	else
		for (i = 0; i < header->in_cnt; i++)
		{
			kfprintf(file, ".IP \"%s -\" 18\n", header->input[i][0]);
			if (header->input[i][1] != NULL)
				kfprintf(file, "%s\n", header->input[i][1]);
			else
			{
				kwarn(KCODEGEN, routine,
				      "routine '%s' does not have an "
				      "explanation for the input parameter "
				      "'%s'\n",
				      header->name, header->input[i][0]);
				kfprintf(file, "No explaination available.\n");
			}
		}
	kfprintf(file, ".SH OUTPUT\n");
	if (header->out_cnt <= 0)
	{
		kfprintf(file, ".LP\n");
		kfprintf(file, "none\n");
	}
	else
		for (i = 0; i < header->out_cnt; i++)
		{
			kfprintf(file, ".IP \"%s -\" 18\n", header->output[i][0]);
			if (header->output[i][1] != NULL)
				kfprintf(file, "%s\n", header->output[i][1]);
			else
			{
				kwarn(KCODEGEN, routine,
				      "routine '%s' does not have an "
				      "explanation for the output parameter "
				      "'%s'\n",
				      header->name, header->output[i][0]);
				kfprintf(file, "No explaination available.\n");
			}
		}

	kfprintf(file, ".SH RETURN VALUE\n");
	if (header->returns == NULL)
		kfprintf(file, "none\n");
	else
		kfprintf(file, "%s\n", header->returns);

	kfprintf(file, ".SH DESCRIPTION\n");
	_kgen_insert_lp(file, header->purpose);

	kfprintf(file, ".SH ADDITIONAL INFORMATION\n");
	if (add_info == NULL)
	{
		kfprintf(file, ".LP\n");
		kfprintf(file, "none\n");
	}
	else
		kfprintf(file, "%s", add_info);
	kfree(add_info);

	kfprintf(file, ".SH EXAMPLES\n");
	if (ex_info == NULL)
	{
		kfprintf(file, ".LP\n");
		kfprintf(file, "none\n");
	}
	else
		kfprintf(file, "%s", ex_info);
	kfree(ex_info);
	kfprintf(file, ".SH SIDE EFFECTS\n");
	_kgen_insert_lp(file, header->sideeff);

	kfprintf(file, ".SH RESTRICTIONS\n");
	_kgen_insert_lp(file, header->restrictions);

	kfprintf(file, ".SH MODIFICATION\n");
	_kgen_insert_lp(file, header->mods);

	kfprintf(file, ".SH FILES\n");
	_kgen_insert_lp(file, header->filename);

	kfprintf(file, ".SH SEE ALSO\n");
	if (sa_info == NULL)
		kfprintf(file, "%s(3)\n", lib_name);
	else
		kfprintf(file, "%s", sa_info);
	kfree(sa_info);

/*
    kfprintf(file, ".SH AUTHOR\n");
    _kgen_insert_lp(file, header->author);
*/

	kfprintf(file, ".SH COPYRIGHT\n");
	if (copyright != NULL)
	{
	   kfprintf(file, "%s\n",copyright);
	   kfree(copyright);
	}

	kfclose(file);

	if (!kgen_generate_whatis(object, header->name, header->shortdesc))
		kinfo(KSYSLIB, "Unable to update the toolbox whatis file.");
	kfree(upper);

	/* Add the manpage to the toolbox manpage database */
	if (path != NULL)
	{
		kdbm   *dbm;
		kdatum  key,
		        data;
		char    temp[KLENGTH],
		        temp2[KLENGTH];

		ksprintf(temp, "$%s/repos/db/manpage", tb_name);
		if ((dbm = kdbm_open(temp, O_WRONLY | O_CREAT, 0666)) != NULL)
		{
		    ksprintf(temp, "$%s", tb_name);
		    if (kfullpath(temp, NULL, temp2) == NULL)
			return(FALSE);
		    key.dptr = header->name;
		    key.dsize = kstrlen(key.dptr) + 1;
		    data.dptr = kstring_replace(manpath, temp2, temp, manpath);
		    data.dsize = kstrlen(data.dptr) + 1;
		    kdbm_store(dbm, key, data, KDBM_REPLACE);
		    kdbm_close(dbm);
		}

		ksprintf(temp, "%s/db/function", opath);
		if ((dbm = kdbm_open(temp, O_WRONLY | O_CREAT, 0666)) != NULL)
		{
			key.dptr = header->name;
			key.dsize = kstrlen(key.dptr) + 1;
			data.dptr = header->filename;
			data.dsize = kstrlen(data.dptr) + 1;
			kdbm_store(dbm, key, data, KDBM_REPLACE);
			kdbm_close(dbm);
		}
	}
	return (TRUE);
}
