#! /bin/sh

# ---------------------------------------------------------------
# This script must be named test.sh
# ---------------------------------------------------------------

# run the compiled program and compare the output against a baseline
ktest > test.out
cmp -s test.out baseline

# Assign status according to the result of the comparison.  
# On failure, status is set to 1.  
if [ $? = 0 ]; then
   status=0
else
   status=1
fi

# ---------------------------------------------------------------
#  Clean up any left-over files your .c file may have generated 
# ---------------------------------------------------------------
rm -rf test.xv test.out

# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------
exit $status

