/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Toolbox creation routines
   >>>>
   >>>>   Static:
   >>>>
   >>>>   Private:
   >>>>
   >>>>   Public:
   >>>>		kcms_get_copyright()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

typedef struct
{
   int      language;
   kstring  opening;
   kstring  prefix;
   kstring  closing;
} CommentInfo;

static CommentInfo comments[] =
{
   {KCMS_LANG_NONE,       NULL,   NULL,      NULL},
   {KCMS_LANG_C,          "/*",   " * ",     " */"},
   {KCMS_LANG_FORTRAN,    NULL,   "C ",      NULL},
   {KCMS_LANG_PERL,       NULL,   "# ",      NULL},
   {KCMS_LANG_CSH,        NULL,   "# ",      NULL},
   {KCMS_LANG_SH,         NULL,   "# ",      NULL},
   {KCMS_LANG_KSH,        NULL,   "# ",      NULL},
   {KCMS_LANG_CPLUSPLUS,  NULL,   "// ",     NULL},
   {KCMS_LANG_ADA,        NULL,   "-- ",     NULL},

   {KCMS_LANG_ROFF,       NULL,   ".\\\" ",  NULL},
   {KCMS_LANG_TEX,        NULL,   "% ",      NULL},
   {KCMS_LANG_KHOROS_UIS, NULL,   "# ",      NULL},
   {KCMS_LANG_HTML,       "<!--", "  -- ",   "  -->"}
};

/************************************************************
* Routine Name: kcms_get_copyright - get copyright comment for toolbox
*
* Purpose:	This routine is used to determine the copyright statement
*		comment which should be used for a specified toolbox.
*
*		If the relevant copyright attribute is defined then this
*		will be used, otherwise the copyright statement from
*		the BOOTSTRAP toolbox will be used.
*
* Input:	toolbox   - The toolbox object we want a copyright for.
*	        attribute - The attribute identifier for the copyright to use;
*			    each toolbox can have two copyright statements
*			    associated with it, short and long.
*			    Legal values for this parameter are:
*			    \f(CW\s-2KCMS_TB_COPYRIGHT_SHORT\fP\s+2, or
*			    \f(CW\s-2KCMS_TB_COPYRIGHT_SHORT\fP\s+2.
*		language  - The language we want this for.
*			    The following languages are currently supported:
*			    !\f(CW\s-2
*			    !   KCMS_LANG_C
*			    !   KCMS_LANG_FORTRAN
*			    !   KCMS_LANG_PERL
*			    !   KCMS_LANG_CSH
*			    !   KCMS_LANG_SH
*			    !   KCMS_LANG_KSH
*			    !   KCMS_LANG_CPLUSPLUS
*			    !   KCMS_LANG_ADA
*			    !   KCMS_LANG_ROFF
*			    !   KCMS_LANG_TEX
*			    !   KCMS_LANG_HTML
*			    !   KCMS_LANG_KHOROS_UIS
*			    !\fP\s+2
*
* Returns:	If the appropriate copyright could be found, then a string
*		is returned which contains the copyright formatted within
*		a comment for the specified language.
*		If a copyright could not be found, or some other error
*		occurred, then NULL will be returned.
*
*		NOTE: the string returned is kmalloc'd for your use.
*		You should free the string when you are done.
* Written By:	Neil Bowers
* Date:		21-jun-94
*************************************************************/
kstring
kcms_get_copyright(
   kobject  toolbox,
   int      attribute,
   int      language)
{
   kstring       routine    = "kcms_get_copyright()";
   kstring       copyright;
   kstring       tbname;
   CommentInfo  *cinfo      = NULL;
   kstring       result     = NULL;
   kstring       tmp;
   int           i;
   char        **list;
   int           nlines;


   if (!kcms_legal_object(toolbox, routine))
      return NULL;

   /*-- get the raw copyright string from the toolbox -----------------*/
   if (!kcms_get_attribute(toolbox, attribute, &copyright)
       || !kcms_get_attribute(toolbox, KCMS_NAME, &tbname))
      return NULL;

   if (copyright == NULL)
   {
      kerror(KCMS, routine, "Could not determine a copyright string.");
      return NULL;
   }

   /*-- split the copyright into lines --------------------------------*/
   list = kparse_string_delimit(copyright, "\n", KDELIM_CLEAN, &nlines);

   for (i=0; i<knumber(comments); i++)
   {
      if (comments[i].language == language)
	 cinfo = &comments[i];
   }

   if (cinfo == NULL)
   {
      kerror(NULL, routine, "Could not find comment information for the "
	     "language specified (%d).\n", language);
      return NULL;
   }

   /*-- does the language have an opening comment construct? ----------*/
   if (cinfo->opening != NULL)
      result = kstring_cat(cinfo->opening, "\n", NULL);

   /*-- prepend the comment prefix to each line, add to comment -------*/
   for (i=0; i<nlines; i++)
   {
      tmp = kstring_3cat(result, cinfo->prefix, list[i], NULL);
      kfree(result);
      result = kstring_cat(tmp, "\n", NULL);
      kfree(tmp);
   }
   karray_free(list, nlines, NULL);

   /*-- does the language have an closing comment construct? ----------*/
   if (cinfo->closing != NULL)
   {
      tmp = kstring_3cat(result, cinfo->closing, "\n", NULL);
      kfree(result);
      result = tmp;
   }

   return result;
}
