/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Toolbox public functions
   >>>>	Static:
   >>>>
   >>>>	Private:
   >>>>
   >>>>	Public:
   >>>>		kcms_open_toolbox()
   >>>>		kcms_create_toolbox()
   >>>>		kcms_add_toolbox()
   >>>>		kcms_get_objects()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "toolboxP.h"
#include "databaseP.h"


/************************************************************
* Routine Name:	kcms_create_toolbox - create a new toolbox object
*
* Purpose:	This function creates the directory structure for a new
*		toolbox, and the minimum number of configuration files
*		required for a toolbox.
*
* Input:	tbname	- The name to be given to the new toolbox.
*		tbpath	- The path to the top of the toolbox.
*
* Returns:	If the toolbox was successfully created,
*		then an object referenced is returned for the new toolbox.
*		If the toolbox could not be created,
*		then NULL is returned,
*		and \f(CW\s-1errno\s+1\fP is set to signify the error.
*
* Written By:	Neil Bowers
* Date:		26-mar-94
*************************************************************/
kobject 
kcms_create_toolbox(
   kstring  tbname,
   kstring  tbpath)
{
   kstring  routine  = "Create Toolbox";
   char     fullpath[KLENGTH];


   if (kcms_env_getpath(tbname) != NULL)
      kerror(KCMS,routine,"There is already a `%s' toolbox.",tbname);

   else if (!kcms_legal_identifier(tbname, KOBJ_CMSTB))
      kerror(KCMS,routine,"Invalid toolbox name --"
	     "you can not have a toolbox called \"%s\".",tbname);

   else if (kfullpath(tbpath,NULL,fullpath) == NULL)
      kerror(KCMS, routine, "Could not expand path for Toolbox '%s'", tbname);

   else
      return kcms_tb_create(tbname,fullpath);

   /*-- failed if we hit here --*/
   return NULL;
}

/************************************************************
* Routine Name:	kcms_add_toolbox - add an existing toolbox
*
* Purpose:	This routine adds an existing toolbox to your
*		khoros working environment, making that toolbox
*		visible to the user.
*
* Input:	tbname	- The name of an existing toolbox.
*		tbpath	- The path to the top of the toolbox.
* Output:	
* Returns:	A kobject pointer to the toolbox object,
*		or NULL if the toolbox could not be opened.
*		In the latter case,
*		\f(CW\s-1errno\s+1\fP is set to signify the error.
*
* Written By:	Neil Bowers
* Date:		24-mar-94
*************************************************************/
kobject 
kcms_add_toolbox(
   kstring  tbname,
   kstring  tbpath)
{
   kstring  routine            = "Add Toolbox";
   kobject  toolbox	       = NULL;
   char	    fullpath[KLENGTH];


   if (tbname == NULL || tbpath == NULL)
      kerror(KCMS,routine,"Name and/or Path are NULL\n");

   else if (kcms_env_getpath(tbname) != NULL)
      kerror(KCMS,routine, "Toolbox '%s' is already installed", tbname);

   else if (kfullpath(tbpath,NULL,fullpath) == NULL)
      kerror(KCMS,routine, "Could not expand path for Toolbox '%s'", tbname);

   else if (!kcms_env_addtb(tbname,fullpath))
      kerror(KCMS,routine,"Call to kcms_env_addtb() failed\n");

   else if ((toolbox = kcms_open_toolbox(tbname)) == NULL)
      kerror(KCMS,routine,"Cannot open toolbox");

   return toolbox;
}

/************************************************************
* Routine Name:	kcms_get_objects - get a list of typed objects from toolbox
*
* Purpose:	This routine is used to query a toolbox for a list of all
*		software objects of a given type.
*
* Input:	toolbox - The toolbox object to query.
*		reqtype	- The type of object(s) we're interested in.
*			  This can be one or more of the supported software
*			  object types, which are:
*			  !\f(CW\s-1
*			  !   KCMS_KROUTINE
*			  !   KCMS_XVROUTINE
*			  !   KCMS_LIBRARY
*			  !   KCMS_PANE
*			  !   KCMS_SCRIPT
*			  !\s+1\fP
*			  The object type identifiers can be or'd together
*			  to request more than one object type:
*			  !\f(CW\s-1
*			  !   ( KCMS_KROUTINE | KCMS_XVROUTINE | KCMS_PANE )
*			  !\s+1\fP
*
* Returns:	A pointer to the first element of a klist of software
*		objects, or NULL if no software objects of the specified
*		type were found.
*
* Written By:	Neil Bowers
* Date:		23-jun-94
*************************************************************/
klist *
kcms_get_objects(
   kobject  toolbox,
   int      reqtype)
{
   klist    *softobjects;
   klist    *result       = NULL;
   kobject   object;
   int       otype;
   int       token;


   if (!kcms_get_attribute(toolbox, KCMS_TB_SOFTWARE_OBJECTS, &softobjects))
      return NULL;

   for (; softobjects != NULL; softobjects = klist_next(softobjects))
   {
      object = (kobject)klist_clientdata(softobjects);
      if (object != NULL
	  && kcms_get_attribute(object, KCMS_CMOBJ_PROGTYPE, &otype)
	  && kcms_get_attribute(object, KCMS_CMOBJ_ONAME_TKN, &token))
      {
	 if ((otype & reqtype) != KCMS_NONE)
	    result = klist_add(result, (kaddr)token, (kaddr)object);
      }
   }

   return result;
}
