/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Display Utility Routines
   >>>>
   >>>>   Static:
   >>>>
   >>>>  Private:
   >>>>
   >>>>   Public:
   >>>>
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "fileP.h"

/*-----------------------------------------------------------------------
|	attribute handlers for GETTING attributes
-----------------------------------------------------------------------*/
static kbool _kcms_fobj_get_tknstr	PROTO((kobject, int, kva_list *));
static kbool _kcms_fobj_get_int_attr	PROTO((kobject, int, kva_list *));
static kbool _kcms_fobj_get_parent	PROTO((kobject, int, kva_list *));
static kbool _kcms_fobj_get_date	PROTO((kobject, int, kva_list *));

/*-----------------------------------------------------------------------
|	attribute handlers for SETTING attributes
-----------------------------------------------------------------------*/
static kbool _kcms_fobj_set_flagval	PROTO((kobject, int, kva_list *));
static kbool _kcms_fobj_set_modified	PROTO((kobject, int, kva_list *));
static kbool _kcms_fobj_set_fullname	PROTO((kobject, int, kva_list *));
static kbool _kcms_fobj_set_basename	PROTO((kobject, int, kva_list *));
static kbool _kcms_fobj_set_date	PROTO((kobject, int, kva_list *));

 /* table to match attributes with tokens and actions */
AttrTbl fattr_tbl[] =
{
   {0, NULL, NULL},

   /*-- attributes which are common to all software objects -----------*/

   {KCMS_NAME,               _kcms_fobj_get_tknstr,
                             _kcms_fobj_set_basename},

   {KCMS_TYPE,		     _kcms_fobj_get_int_attr,
                             NULL},

   {KCMS_PATH,               _kcms_fobj_get_tknstr,
                             _kcms_fobj_set_fullname},

   {KCMS_PARENT,             _kcms_fobj_get_parent,
                             NULL},

   {KCMS_DATE,               _kcms_fobj_get_date,
                             _kcms_fobj_set_date},

   /*-- attributes which are specific to file objects -----------------*/

   {KCMS_FOBJ_TYPE,          _kcms_fobj_get_int_attr,
                             _kcms_fobj_set_flagval},

   {KCMS_FOBJ_SUBTYPE,       _kcms_fobj_get_int_attr,
                             _kcms_fobj_set_flagval},

   {KCMS_FOBJ_GENERATED,     _kcms_fobj_get_int_attr,
                             _kcms_fobj_set_flagval},

   {KCMS_FOBJ_ACCESS,        _kcms_fobj_get_int_attr,
                             _kcms_fobj_set_flagval},

   {KCMS_FOBJ_DIRNAME,       _kcms_fobj_get_tknstr,
                             NULL},

   {KCMS_FOBJ_DIRNAME_TKN,   _kcms_fobj_get_tknstr,
                             NULL},

   {KCMS_FOBJ_BASENAME_TKN,  _kcms_fobj_get_tknstr,
                             NULL},

   {KCMS_FOBJ_FULLNAME_TKN,  _kcms_fobj_get_tknstr,
                             NULL},

   {KCMS_FOBJ_MODIFIED,      NULL,
                             _kcms_fobj_set_modified}
};

static kbool 
_kcms_fobj_get_int_attr(
   kobject    object,
   int	      attribute,
   kva_list  *list)
{
   kstring   routine = "Get Integer Attribute";
   kbool     status  = TRUE;
   int      *int_ptr;


   int_ptr = kva_arg(*list, int *);
   switch (attribute)
   {
      case KCMS_TYPE:
	 *int_ptr = object->type;
	 break;

      case KCMS_FOBJ_TYPE:
	 *int_ptr = object->ftype;
	 break;

      case KCMS_FOBJ_SUBTYPE:
	 *int_ptr = object->subtype;
	 break;

      case KCMS_FOBJ_GENERATED:
	 *int_ptr = object->generated;
	 break;

      case KCMS_FOBJ_ACCESS:
	 *int_ptr = object->access;
	 break;

      default:
	 kerror(KCMS, routine,
		"called with illegal attribute value\n");
	 status = FALSE;
	 break;
   }

   return status;
}


static kbool
_kcms_fobj_get_int(
   kva_list  *list,
   int       value)
{
   int       *ptr;


   ptr = kva_arg(*list, int *);
   *ptr = value;
   return TRUE;
}

static kbool
_kcms_fobj_get_str(
   kva_list  *list,
   int       token)
{
   char      **ptr;


   ptr = kva_arg(*list, char **);
   *ptr = ktoken_to_string(token);
   if (*ptr == NULL)
      errno = KCMS_TOKENERR;
   return ((*ptr == NULL) ? FALSE : TRUE);
}

static kbool
_kcms_fobj_get_tknstr(
   kobject   object,
   int       attr,
   kva_list  *list)
{
   int       status;


   switch (attr)
   {
      case KCMS_FOBJ_DIRNAME:
      case KCMS_FOBJ_DIRNAME_TKN:
	 if (object->dirname == 0)
	 {
	    char *ptr;
	    ptr = kdirname(ktoken_to_string(
					      object->fullname), NULL);
	    object->dirname = kstring_to_token(ptr);
	    kfree(ptr);
	 }
	 status = (((attr == KCMS_FOBJ_DIRNAME) ?
		    _kcms_fobj_get_str(list, object->dirname) :
		    _kcms_fobj_get_int(list, object->dirname)));
	 break;

      case KCMS_NAME:
      case KCMS_FOBJ_BASENAME_TKN:
	 if (object->basename == 0)
	 {
	    char *ptr;
	    ptr = kbasename(ktoken_to_string(
					       object->fullname), NULL);
	    object->basename = kstring_to_token(ptr);
	    kfree(ptr);
	 }
	 status = (((attr == KCMS_NAME) ?
		    _kcms_fobj_get_str(list, object->basename) :
		    _kcms_fobj_get_int(list, object->basename)));
	 break;

      case KCMS_PATH:
	 status = _kcms_fobj_get_str(list, object->fullname);
	 break;

      case KCMS_FOBJ_FULLNAME_TKN:
	 status = _kcms_fobj_get_int(list, object->fullname);
	 break;

      default:
	 errno = KCMS_INVALIDATTRIBUTE;
	 kerror(KCMS, "Set File Object Flag",
		"Invalid attribute passed to handler.");
	 status = FALSE;
   }
   return status;
}

/* ARGSUSED */
static kbool
_kcms_fobj_get_parent(
   kobject   object,
   int       attr,
   kva_list  *list)
{
   kobject   *ptr;


   ptr = kva_arg(*list, kobject *);
   *ptr = object->parent;
   return TRUE;
}

/*--------------------------------------------------------------*/

static kbool
_kcms_fobj_set_int(
   kva_list  *list,
   int       *value,
   int       min,
   int       max)
{
   int       val;


   val = kva_arg(*list, int);
   if (min != max && max != 0 && (val < min || val > max))
   {
      errno = KCMS_RANGEERR;
      return FALSE;
   }
   *value = val;
   return TRUE;
}

static kbool
_kguess_type(
   kobject object)
{
   kstring  suffix;
   kstring  dirname;
   kstring  basename;
   kstring  none = "none";
   int      origtype;


   if (kcms_get_attribute(object, KCMS_FOBJ_DIRNAME, &dirname) == FALSE)
      return FALSE;
   if (kcms_get_attribute(object, KCMS_NAME, &basename) == FALSE)
      return FALSE;
   if ((suffix = kstrrchr(basename, '.')) == NULL)
      suffix = none;
   else
      suffix++;
   origtype = object->ftype;
   if (kstrcasecmp(suffix, "c") == 0 || kstrcmp(suffix, "cxx") == 0 ||
       kstrcmp(suffix, "f") == 0 || kstrcmp(suffix, "cc") == 0 ||
       kstrcmp(suffix, "m") == 0 || kstrcmp(suffix, "l") == 0 ||
       kstrcmp(suffix, "lex") == 0 || kstrcmp(suffix, "y") == 0 ||
       kstrcmp(suffix, "h") == 0)
   {
      object->ftype = KCMS_FOBJ_TYPE_SRC;
      if (kstrcmp(suffix, "c") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_C;
      else if (kstrcmp(suffix, "h") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_INCL;
      else if (kstrcmp(suffix, "y") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_YACC;
      else if (kstrcmp(suffix, "l") == 0 ||
	       kstrcmp(suffix, "lex") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_LEX;
      else if (kstrcmp(suffix, "f") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_FORTRAN;
      else if (kstrcmp(suffix, "C") == 0 ||
	       kstrcmp(suffix, "cxx") == 0 ||
	       kstrcmp(suffix, "cc") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_CPLUSPLUS;
      else if (kstrcmp(suffix, "m") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_OBJC;
      else
      {
	 object->ftype = origtype;
	 errno = KCMS_RANGEERR;
	 return FALSE;
      }
   }
   else if (suffix == none && kstrstr(dirname, "/man/") != NULL)
   {
      object->ftype = KCMS_FOBJ_TYPE_MAN;
      object->subtype = KCMS_FOBJ_SUBTYPE_MAN1;
   }
   else if (kstrcmp(suffix, "doc") == 0 || kstrcmp(suffix, "hlp") == 0 ||
	    (suffix == none && kstrstr(dirname, "/help/") != NULL))
   {
      object->ftype = KCMS_FOBJ_TYPE_HELP;
      if (kstrcmp(suffix, "doc") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_DOC;
      else if (kstrcmp(suffix, "hlp") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_HELP;
      else
	 object->subtype = KCMS_FOBJ_SUBTYPE_FORMATTED;
   }
   else if (kstrcmp(suffix, "ms") == 0 || kstrcmp(suffix, "man") == 0 ||
	    kstrcmp(suffix, "sec") == 0 || kstrcmp(suffix, "ps") == 0)
   {
      object->ftype = KCMS_FOBJ_TYPE_MANUAL;
      if (kstrcmp(suffix, "man") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_MAN;
      else if (kstrcmp(suffix, "ms") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_MS;
      else if (kstrcmp(suffix, "sec") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_SEC;
      else if (kstrcmp(suffix, "ps") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_PS;
      else
      {
	 object->ftype = origtype;
	 errno = KCMS_RANGEERR;
	 return FALSE;
      }
   }
   else if (kstrcmp(suffix, "pane") == 0 || kstrcmp(suffix, "form") == 0 ||
	    kstrcmp(suffix, "cmd") == 0)
   {
      object->ftype = KCMS_FOBJ_TYPE_UIS;
      if (kstrcmp(suffix, "pane") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_PANE;
      else if (kstrcmp(suffix, "form") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_FORM;
      else if (kstrcmp(suffix, "subform") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_MISC;
      else
      {
	 object->ftype = origtype;
	 errno = KCMS_RANGEERR;
	 return FALSE;
      }
   }
   else if (kstrcmp(suffix, "sh") == 0 || kstrcmp(suffix, "pl") == 0 ||
	    kstrcmp(suffix, "csh") == 0)
   {
      object->ftype = KCMS_FOBJ_TYPE_SCRIPT;
      if (kstrcmp(suffix, "sh") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_SH;
      else if (kstrcmp(suffix, "pl") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_PERL;
      else if (kstrcmp(suffix, "csh") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_CSH;
      else
      {
	 object->ftype = origtype;
	 errno = KCMS_RANGEERR;
	 return FALSE;
      }
   }
   else if (kstrcmp(suffix, "cm") == 0 || kstrcmp(suffix, "pag") == 0 ||
	    kstrcmp(suffix, "dir") == 0 ||
	    (suffix == none && kstrcmp(basename, "Imakefile")))
   {
      object->ftype = KCMS_FOBJ_TYPE_DBM;
      if (kstrcmp(suffix, "cm") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_CM;
      else if (kstrcmp(suffix, "pag") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_SDBM_PAG;
      else if (kstrcmp(suffix, "dir") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_SDBM_DIR;
      else if (kstrcmp(basename, "Imakefile") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_IMAKEFILE;
      else
      {
	 object->ftype = origtype;
	 errno = KCMS_RANGEERR;
	 return FALSE;
      }
   }
   else if (!kstrcmp(suffix, "todo") || !kstrcmp(suffix, "bugs") ||
	    !kstrcmp(suffix, "done") || !kstrcmp(suffix, "changelog"))
   {
      object->ftype = KCMS_FOBJ_TYPE_INFO;
      if (kstrcmp(suffix, "todo") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_TODO;
      else if (kstrcmp(suffix, "bugs") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_BUGS;
      else if (kstrcmp(suffix, "done") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_DONE;
      else if (kstrcmp(suffix, "changelog") == 0)
	 object->subtype = KCMS_FOBJ_SUBTYPE_CHANGELOG;
      else
      {
	 object->ftype = origtype;
	 errno = KCMS_RANGEERR;
	 return FALSE;
      }
   }
   else
   {
      kinfo(KSYSLIB,
      "_kguess_type: type cannot be guessed, assuming KCMS_FOBJ_TYPE_MISC");
      object->ftype = KCMS_FOBJ_TYPE_MISC;
      object->subtype = KCMS_FOBJ_SUBTYPE_NONE;
   }
   return TRUE;
}

static kbool
_kcms_fobj_set_flagval(
   kobject   object,
   int       attr,
   kva_list  *list)
{
   int status = FALSE;


   switch (attr)
   {
      case KCMS_FOBJ_TYPE:
	 status = kva_arg(*list, int);
	 if (status == -1)
	    status = _kguess_type(object);
	 else if (status < KCMS_FOBJ_TYPE_MISC ||
		  status > KCMS_FOBJ_TYPE_CONFIG)
	 {
	    errno = KCMS_RANGEERR;
	    status = FALSE;
	 }
	 else
	 {
	    object->ftype = status;
	    status = TRUE;
	 }
	 break;

      case KCMS_FOBJ_SUBTYPE:
	 switch (object->ftype)
	 {
	    case KCMS_FOBJ_TYPE_MISC:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_NONE,
					   KCMS_FOBJ_SUBTYPE_NONE);
	       break;
	    case KCMS_FOBJ_TYPE_SRC:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_NONE,
					   KCMS_FOBJ_SUBTYPE_LEX);
	       break;
	    case KCMS_FOBJ_TYPE_MAN:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_MAN1,
					   KCMS_FOBJ_SUBTYPE_CAT3);
	       break;
	    case KCMS_FOBJ_TYPE_HELP:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_DOC,
					   KCMS_FOBJ_SUBTYPE_FORMATTED);
	       break;
	    case KCMS_FOBJ_TYPE_MANUAL:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_MS,
					   KCMS_FOBJ_SUBTYPE_PS);
	       break;
	    case KCMS_FOBJ_TYPE_UIS:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_FORM,
					   KCMS_FOBJ_SUBTYPE_MISC);
	       break;
	    case KCMS_FOBJ_TYPE_SCRIPT:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_SH,
					   KCMS_FOBJ_SUBTYPE_TCSH);
	       break;
	    case KCMS_FOBJ_TYPE_DBM:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_NONE,
					   KCMS_FOBJ_SUBTYPE_WORKSPACE);
	       break;
	    case KCMS_FOBJ_TYPE_INFO:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_NONE,
					   KCMS_FOBJ_SUBTYPE_DESCRIPTION);
	       break;
	    case KCMS_FOBJ_TYPE_CONFIG:
	       status = _kcms_fobj_set_int(list,
					   &object->subtype,
					   KCMS_FOBJ_SUBTYPE_NONE,
					   KCMS_FOBJ_SUBTYPE_APP_DEFAULTS);
	       break;
	 }
	 break;

      case KCMS_FOBJ_GENERATED:
	 status = _kcms_fobj_set_int(list, &object->generated,
				     KCMS_FOBJ_GEN_NONE, KCMS_FOBJ_GEN_COND);
	 if (status)
	 {
	    if (object->generated >= KCMS_FOBJ_GEN_MAIN &&
		object->generated <= KCMS_FOBJ_GEN_HELP)
	       object->update_routine = kghost_update_file;
	    else
	       object->update_routine = NULL;
	    if (object->parent->mod_sub_obj != NULL)
	       status = object->parent->mod_sub_obj(
						    object->parent, object);
	 }
	 break;

      case KCMS_FOBJ_ACCESS:
	 status = _kcms_fobj_set_int(list, &object->access,
			    KCMS_FOBJ_ACCESS_RDWR, KCMS_FOBJ_ACCESS_RDONLY);
	 break;

      default:
	 kerror(KCMS, "Set File Object Flag",
		"Invalid attribute passed to handler.");
	 errno = KCMS_INVALIDATTRIBUTE;
	 status = FALSE;
   }
   return status;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_fobj_set_fullname - set KCMS_PATH attribute
|
| Purpose:	This should be a complete description that anyone
|		could understand;  it should have acceptable grammar
|		and correct spelling.
|
| Input:	object	- file object we're updating
|		attr	- attribute identifier
|		list	- varargs list from which we pull the new value.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		8-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
static kbool
_kcms_fobj_set_fullname(
   kobject   object,
   int       attr,
   kva_list  *list)
{
   kstring        routine = "Set FULLNAME file attribute";
   kstring        newpath;
   kstring        oldpath;
   unsigned long  update;


   if (object->ftype == KCMS_FOBJ_TYPE_DBM)
   {
      kerror(KCMS, routine,
             "You are not allowed to rename the object database files!");
      return FALSE;
   }

   kcms_get_attribute(object->parent, KCMS_CMOBJ_UPDATE_DB, &update);
   newpath = kva_arg(*list, char *);
   if ((oldpath = ktoken_to_string(object->fullname)) == NULL)
   {
      kerror(KCMS, "Set FULLNAME Attribute", "failed to get old path.");
      return FALSE;
   }
   if (krename(oldpath, newpath) == -1)
   {
      kerror(KCMS, routine,
	     "Failed to rename file, from:\n\t%s to\n\t%s",
	     oldpath, newpath);
      return FALSE;
   }
   object->fullname = object->cm_name = kstring_to_token(newpath);
   object->basename = 0;
   update |= KCMS_UPDATE_SYNC;
   if (object->ftype == KCMS_FOBJ_TYPE_SRC ||
       object->ftype == KCMS_FOBJ_TYPE_SCRIPT)
      update |= KCMS_UPDATE_REGEN;
   kcms_set_attribute(object->parent, KCMS_CMOBJ_UPDATE_DB, update);
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	_kcms_fobj_set_basename - set KCMS_NAME attribute
|
| Purpose:	This should be a complete description that anyone
|		could understand;  it should have acceptable grammar
|		and correct spelling.
|
| Input:	object    - The file object we're updating
|		attribute - attribute identifier
|		list      - varargs list from which we pull the new value.
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		10-jul-94
------------------------------------------------------------*/
/* ARGSUSED */
static kbool
_kcms_fobj_set_basename(
   kobject    file_object,
   int        attr,
   kva_list  *list)
{
   kstring  routine = "Set FULLNAME file attribute";
   kstring  directory;
   kstring  newname;
   char     fullpath[KLENGTH];


   if (file_object->ftype == KCMS_FOBJ_TYPE_DBM)
   {
      kerror(KCMS, routine,
             "You are not allowed to rename the object database files!");
      return FALSE;
   }

   if (!kcms_get_attribute(file_object, KCMS_FOBJ_DIRNAME, &directory))
      return FALSE;

   /*-- get the new basename for the file from varargs list -----------*/
   newname = kva_arg(*list, kstring);

   ksprintf(fullpath, "%s/%s", directory, newname);

   return kcms_set_attribute(file_object, KCMS_PATH, fullpath);
}

/* ARGSUSED */
static kbool
_kcms_fobj_set_modified(
   kobject   object,
   int       attr,
   kva_list  *list)
{
   if (object->update_routine != NULL)
      return object->update_routine(object->parent, object->generated);
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	kcms_fobj_attr_tbl - get the attribute table for file objects
|
| Purpose:	This should be a complete description that anyone
|		could understand;  it should have acceptable grammar
|		and correct spelling.
|
| Returns:	The table holding details of file object attributes.
|
| Written By:	Steven Jorgensen
| Date:		29-jun-94
------------------------------------------------------------*/
AttrTbl *
kcms_fobj_attr_tbl(void)
{
   return fattr_tbl;
}

static kbool 
_kcms_fobj_get_date(
   kobject    object,
   int	      attribute,
   kva_list  *valist)
{
   kstring      *string_ptr;
   struct stat   buf;
   kstring       file_path;
   kstring       fullpath;
   struct tm    *time_struct;
   char          buffer[KLENGTH];


   /*-- creation time: not applicable for files -----------------------*/
   if ((string_ptr = kva_arg(*valist, kstring *)) != NULL)
      *string_ptr = NULL;

   /*-- modification time ---------------------------------------------*/
   if ((string_ptr = kva_arg(*valist, kstring *)) != NULL)
   {
      *string_ptr = NULL;
      if (kcms_get_attribute(object, KCMS_PATH, &file_path)
	  && (fullpath = kfullpath(file_path, NULL, NULL)) != NULL
	  && stat(fullpath, &buf) != -1
	  && (time_struct = localtime(&buf.st_mtime)) != NULL
	  && kstrftime(buffer, KLENGTH, KCMS_DATE_FORMAT, time_struct) != 0)
      {
	 *string_ptr = kstrdup(buffer);
	 kfree(fullpath);
      }
   }

   /*-- generation time: not applicable for files ---------------------*/
   if ((string_ptr = kva_arg(*valist, kstring *)) != NULL)
      *string_ptr = NULL;

   return TRUE;
}

static kbool 
_kcms_fobj_set_date(
   kobject    object,
   int	      attribute,
   kva_list  *list)
{
   kwarn(KCMS, "_kcms_fobj_set_date()",
	 "Attempt to set the KCMS_DATE attribute for a file object.\n"
	 "This is currently not supported.\n");
   return TRUE;
}
