/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Database update routines
   >>>>
   >>>>   Static:
   >>>>             _kcms_cmobj_sync()
   >>>>  Private:
   >>>>             kcms_cmobj_sync()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "cmobjP.h"
#include "databaseP.h"

void include_list_to_string PROTO((kobject, klist *, char *));

/*-----------------------------------------------------------
| Routine Name:	_kcms_cmobj_sync - write a cm file out to disk.
|
| Purpose:	This routine takes a cmobj structure
|		and writes a corresponding cm dbm files out to disk.
|
| Input:	cmobj - kobject to write a .cm for.
|
| Output:	
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Nov 04, 1992 14:12
------------------------------------------------------------*/
static int
_kcms_cmobj_sync(
   kobject cmobj)
{
   kstring   routine = "Sync Software Object";
   kdbm     *database;
   kstring   cmfile_name = NULL;
   char      dirname[KLENGTH];
   char      datastr[KLENGTH * 20];
   kstring   tbname;


   errno = KCMS_OK;
   kcms_get_attribute(cmobj->database, KCMS_PATH, &cmfile_name);
   kcms_get_attribute(cmobj->parent, KCMS_NAME, &tbname);

   kdirname(cmfile_name, dirname);
/*
 *    This is unnecessary if we leave the kmake_dir in the kopen
 *      call.  This should be uncommented if we decide to remove the kmake_dir
 *      (SJ) Sep 02, 1993
 *
 *      if (!kmake_dir(dirname, 0777) && errno != EEXIST)
 *      {
 *              errno = KCMS_PERMISSION;
 *              kerror(KCMS,routine, "Cannot create %s\n",dirname);
 *      }
 */
   database = kdbm_open(cmfile_name, (O_WRONLY | O_CREAT), 0666);
   if (database == NULL)
   {
      kerror(KCMS, routine,
	     "Cannot open database for object `%s' for writing\n",
	     cmfile_name);
      errno = KCMS_CMOPENERR;
      return FALSE;
   }

   if ((cmobj->update & KCMS_UPDATE_NEW) == KCMS_UPDATE_NEW)
      kannounce(KCMS, routine, "creating object database [%s::%s]",
		tbname, cmobj->oname);
   else
      kannounce(KCMS, routine, "updating object database [%s::%s]",
		tbname, cmobj->oname);

   kcms_db_update_string(database, CM_VERSION, KCMS_KEY_CMS_VERSION);

   /*------------------------------------------------------------------
   | Save Object Version
   +-----------------------------------------------------------------*/
   kcms_db_update_string(database,
			 kcms_attr_int2string(KCMS_CMOBJ_TYPE,
					      cmobj->prog_type),
			 KCMS_KEY_CMOBJ_TYPE);
   kcms_db_update_string(database,
			 kcms_attr_int2string(KCMS_CMOBJ_LANGTYPE,
					      cmobj->lang_type),
			 KCMS_KEY_CMOBJ_LANG);
   kcms_db_update_string(database, cmobj->bname, KCMS_KEY_CMOBJ_BNAME);
   kcms_db_update_string(database, cmobj->icon_name, KCMS_KEY_ICON_NAME);

   kcms_db_update_string(database, cmobj->poc_email, KCMS_KEY_AUTHOR_EMAIL);
   kcms_db_update_string(database, cmobj->poc_name, KCMS_KEY_AUTHOR);
   kcms_db_update_string(database, cmobj->category, KCMS_KEY_CATEGORY);
   kcms_db_update_string(database, cmobj->subcategory,
			 KCMS_KEY_SUBCATEGORY);
   kcms_db_update_string(database, cmobj->short_description,
			 KCMS_KEY_SHORT_DESCRIPTION);
   kcms_db_update_string(database, cmobj->version,
			 KCMS_KEY_VERSION);

   /*--------------------------------------------------------------------
   |	save list of keywords
   +-----------------------------------------------------------------*/
   kcms_db_update_string_list(database, cmobj->keywords, KCMS_KEY_KEYWORDS);

   /*---------------------------------------------------------------+
   | Save todo/bugs/done/changelog log files for object
   +---------------------------------------------------------------*/
   kcms_db_update_fobj(database, cmobj->todo, KCMS_KEY_TODO);
   kcms_db_update_fobj(database, cmobj->bugs, KCMS_KEY_BUGS);
   kcms_db_update_fobj(database, cmobj->done, KCMS_KEY_DONE);
   kcms_db_update_fobj(database, cmobj->changelog, KCMS_KEY_CHANGELOG);

   /*---------------------------------------------------------------+
   | Save todo/bugs/done/changelog log files for object
   +---------------------------------------------------------------*/
   kcms_db_update_fobj(database, cmobj->workspace, KCMS_KEY_WORKSPACE);

   /*---------------------------------------------------------------+
   | Save Miscellaneous Files list for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->misc_files, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_MISC_FILES);

   /*---------------------------------------------------------------+
   | Save app-defaults Files list for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->app_defaults, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_APP_DEFAULTS);

   /*---------------------------------------------------------------+
   | Save YACC Files list (YSRCS) for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->y_files, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_CMOBJ_YSRCS);

   /*---------------------------------------------------------------+
   | Save LEX Files list (LSRCS) for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->l_files, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_CMOBJ_LSRCS);

   /*---------------------------------------------------------------+
   | Save C Files list (SRCS) for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->c_files, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_CMOBJ_SRCS);

   /*---------------------------------------------------------------+
   | Save F77 Files list (FSRCS) for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->f_files, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_CMOBJ_FSRCS);

   /*---------------------------------------------------------------+
   | Save C++ Files list (C++SRCS) for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->cplus_files, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_CMOBJ_CPLUSPLUS);

   /*---------------------------------------------------------------+
   | Save header files list (HEADERS) for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   /*UPDATE: next line is a kludge --- to be fixed post-2.0 */
   include_list_to_string(cmobj, cmobj->inc_files, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_CMOBJ_HEADERS);

   /*---------------------------------------------------------------+
   | Save header files list (HEADERS) for the program
   +---------------------------------------------------------------*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->script_files, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_CMOBJ_SCRIPTS);

   /*---------------------------------------------------------------+
   | Save UIS File names for program's GUI
   +---------------------------------------------------------------*/
   kcms_db_update_fobj(database, cmobj->pane, KCMS_KEY_CMOBJ_UIS_PANE);
   kcms_db_update_fobj(database, cmobj->form, KCMS_KEY_CMOBJ_UIS_FORM);

   /*-- miscellaneous UIS files --*/
   datastr[0] = '\0';
   obj_list_to_string(cmobj->miscuis, KCMS_PATH, datastr);
   kcms_db_update_string(database, datastr, KCMS_KEY_UIS_MISC);

   /*---------------------------------------------------------------+
   | Save filenames with Ghostwriter tags
   +---------------------------------------------------------------*/
   kcms_db_update_fobj(database, cmobj->cfile, KCMS_KEY_CMOBJ_GHOST_SRC);
   kcms_db_update_fobj(database, cmobj->hfile, KCMS_KEY_CMOBJ_GHOST_HEADER);
   kcms_db_update_string(database, cmobj->library,
			 KCMS_KEY_CMOBJ_GHOST_LIB);
   kcms_db_update_fobj(database, cmobj->man1file,
		       KCMS_KEY_CMOBJ_GHOST_MAN1);
   kcms_db_update_fobj(database, cmobj->man3file,
		       KCMS_KEY_CMOBJ_GHOST_MAN3);
   kcms_db_update_fobj(database, cmobj->helpfile,
		       KCMS_KEY_CMOBJ_GHOST_HELP);
   kcms_db_update_fobj(database, cmobj->scriptfile,
		       KCMS_KEY_CMOBJ_GHOST_SCRIPT);

   /*---------------------------------------------------------------+
   | Save Conductor form update level
   +---------------------------------------------------------------*/
   if (cmobj->prog_type == KCMS_XVROUTINE)
      kcms_db_update_int(database, cmobj->levels,
			 KCMS_KEY_CMOBJ_COND_LEVELS);

   if (cmobj->prog_type == KCMS_PANE && cmobj->assoc_tbname != NULL)
   {
      if (cmobj->assoc_args == NULL)
	 ksprintf(datastr, "%s\n%s\n",
		  cmobj->assoc_tbname, cmobj->assoc_oname);
      else
	 ksprintf(datastr, "%s\n%s\n%s\n", cmobj->assoc_tbname,
		  cmobj->assoc_oname, cmobj->assoc_args);
      kcms_db_update_string(database, datastr, KCMS_KEY_ASSOCIATED_OBJECT);
   }
   else
      kcms_db_remove_key(database, KCMS_KEY_ASSOCIATED_OBJECT);

   /*---------------------------------------------------------------+
   |  Save state information
   +---------------------------------------------------------------*/
   kcms_db_update_string(database,
			 kcms_attr_int2string(KCMS_CMOBJ_CODETYPE,
					      cmobj->code_type),
			 KCMS_KEY_CMOBJ_STATE_CTYPE);
   kcms_db_update_logical(database, cmobj->ci_installed, KCMS_KEY_IN_CANTATA);
   kcms_db_update_logical(database, cmobj->generate_executable,
			  KCMS_KEY_GENERATE_EXECUTABLE);

   /*-- save the three dates associated with a software object --------*/
   if (cmobj->times.modification != NULL)
      kfree(cmobj->times.modification);
   cmobj->times.modification = kcms_get_date();
   kcms_db_write_dates(database, cmobj->times.creation,
		       cmobj->times.modification, cmobj->times.generation);

   kdbm_close(database);

   return TRUE;
}


/*-----------------------------------------------------------
| Routine Name:	kcms_cmobj_sync - update the cm files and imakefile after
|		a set attribute
|
| Purpose:	This routine updates the .cm file and the Imakefile and
|		Makefile from the new kobject created by a set attributes.
|		_kcms_cmobj_sync() actually updates the database.
|
| Input:	cmobj - the kobject to update
| Output:	none
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Steven Jorgensen
| Date:		Nov 18, 1992 15:10
------------------------------------------------------------*/
int
kcms_cmobj_sync(
   kobject cmobj)
{
   kstring        routine      = "kcms_cmobj_sync()";
   int            status       = TRUE;
   unsigned long  update       = cmobj->update;
   unsigned long  orig_update  = cmobj->update;


   if (update == KCMS_UPDATE_NONE)
      return TRUE;
   if (cmobj->database == NULL)
   {
      errno = KCMS_NULLOBJ;
      kerror(KCMS, routine, "No database object found in "
	     "software object -- don't know how to "
	     "synchronize object to disk.");
      return FALSE;
   }

   if ((update & KCMS_UPDATE_NEW) == KCMS_UPDATE_NEW)
   {
      kcms_sync(cmobj->parent);
   }

   if ((update & KCMS_UPDATE_SYNC) == KCMS_UPDATE_SYNC)
   {
      if (!_kcms_cmobj_sync(cmobj))
	 return FALSE;

      update ^= KCMS_UPDATE_SYNC;
   }

   /*-- get error message if cache write gives error, don't fail ------*/
   if ((update & KCMS_UPDATE_CACHE) == KCMS_UPDATE_CACHE)
   {
      (void)kcms_cmobj_update_cache(cmobj);
      update ^= KCMS_UPDATE_CACHE;
   }

   if ((update & KCMS_UPDATE_REGEN) == KCMS_UPDATE_REGEN
       || (update & KCMS_UPDATE_NEW) == KCMS_UPDATE_NEW)
   {
      status = kcms_gen_imakeandmake(cmobj, NULL);
      if ((update & KCMS_UPDATE_REGEN) == KCMS_UPDATE_REGEN)
         update ^= KCMS_UPDATE_REGEN;
      if ((update & KCMS_UPDATE_NEW) == KCMS_UPDATE_NEW)
         update ^= KCMS_UPDATE_NEW;
   }

   if (update != orig_update)
      kcms_set_attribute(cmobj, KCMS_CMOBJ_UPDATE_DB, update);

   return status;
}
