 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for phantomd
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "phantomd.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Executes another process
|
|       Purpose: main program for phantomd
|
|         Input:
|		int clui_info->daemon_logic; {spawn process in background and dis-associate tty}
|		int clui_info->daemon_flag; {TRUE if -daemon specified}
|
|		int clui_info->timeout_int; {number of minutes idle time before quitting}
|		int clui_info->timeout_flag; {TRUE if -timeout specified}
|
|		char *clui_info->transport_string; {type of transport to start the daemon for}
|		int   clui_info->transport_flag; {TRUE if -transport specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	int   ifid, timeout;
	kfile *ifile, *ofile;
	char  *transport, buffer[KLENGTH];
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(phantomd_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "phantomd",
		phantomd_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	phantomd_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	timeout   = clui_info->timeout_int;
	transport = clui_info->transport_string;
	kexit_handler(phantomd_exit, NULL);
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!phantomd_init(transport, timeout, &ifile, &ofile))
	   kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	ifid = kfileno(ifile);
/*
	while (kpoll(&ifid, 1, 0) != -1)
 */
	{
	   if (kfgets(buffer, KLENGTH, ifile))
	   {
	      kfprintf(kstderr,"phantomd: %s", buffer);
	      kfputs("0: 'yes'\n", ofile);
	   }
	}
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: phantomd_usage_additions
| 
|       Purpose: Prints usage additions in phantomd_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname phantomd
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void phantomd_usage_additions(void)
{
	kfprintf(kstderr, "\tExecutes another process\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: phantomd_free_args
| 
|       Purpose: Frees CLUI struct allocated in phantomd_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname phantomd
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
phantomd_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->transport_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
