 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Socket Transport Drivers
   >>>>
   >>>>  Private:
   >>>>			socket_connect
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#if LOCAL_DEF == CRAY_DEF
#  undef _POSIX_SOURCE
#endif

#include "phantomd.h"


#if !defined(KSOCKET_DEF)
RemoteTransport socket_remotetrans[] = {NULL};
#else

#if LOCAL_DEF == SUN_DEF && KSTDC_DEF
#define ushort unsigned short
#define ulong  unsigned long
#define uint   unsigned int
#define uchar  unsigned char
#define hostid_t long

#define u_short ushort
#define u_int   uint
#define u_long  ulong
#define u_char  uchar
#endif

/* Berkeley socket (inet/remote) transport */
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

static int socket_connect      PROTO((kfile *, char *));

RemoteTransport socket_remotetrans[] =
{
    {
	"Standard Socket (AF_UNIX)",
	"socket",
	FALSE,
	socket_connect,
    }
};

/*
 *  Internal resource structures for "Standard Socket (AF_UNIX)" transport
 */
typedef struct
{
	int	socket;
} ResourceStruct;



/*-------------------------------------------------------------------*
|  
|		  Socket Routines
|  
--------------------------------------------------------------------*/

/*-------------------------------------------------------------
|  
|  Routine Name: socket_connect
|  
|       Purpose: This function opens a "socket" connection.  It is an
|	         internal driver to open a socket, which is called by
|	         the the internal socket routines such as socket_open().
|  
|		  	"socket=XXXXXXXXXX"
|  
|  
|         Input:  file - the kfile structure describing the transport
|		  path - the socket path
|          
|        Output:  returns -1 or the socket id
|  
|   Called From:  internal routine called from kopen()
|  
|    Written By:  Mark Young
|          Date:  Jul 08, 1992 16:06
|  
-------------------------------------------------------------*/

/*ARGSUSED*/
static int socket_connect(
   kfile *file,
   char  *path)
{
	unsigned long inaddr;
	struct	 sockaddr_in server;
	struct   hostent *host_machine;
	char	 *machine, name[KLENGTH];
	int      port, sock, nsock, len, reuse;


	/*
	 *  Create either a local UNIX or TCP connection based socket
	 */
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
	   kinfo(KVERBOSE,"socket_connect:  Creation failure for socket '%s'",
			path);
	   return(-1);
	}

	reuse = TRUE;
	if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *) &reuse,
		sizeof(reuse)) < 0)
	{
	   kinfo(KVERBOSE,"socket_connect:  Cannot set option (REUSEADDR) for \
socket '%s'", path);
	   return(-1);
	}

	/*
	 *  Get the path name to connet to, the socket name component of
	 *  the path.
	 */
	if (ksscanf(path,"socket=%s", name) != 1)
	   kstrcpy(name, path);

	/*
	 *  Assign our server's address and then connect to the returned
	 *  socket "server_sock".
	 */
	kmemset((char *) &server, 0, sizeof(server));
	server.sin_family = AF_INET;
	server.sin_port   = port;
	if ((host_machine = gethostbyname(machine)) != NULL)
	{
	   kmemcpy((char *) &server.sin_addr, host_machine->h_addr,
			host_machine->h_length);
	}
	else if ((inaddr = inet_network(machine)) != -1 && inaddr != ~0L)
	{
	   inaddr = htonl(inaddr);
	   kmemcpy((char *) &server.sin_addr, &inaddr, sizeof(inaddr));
	}
	else
	{
	   kinfo(KVERBOSE, "socket_connect:  Hostname lookup failure for \
socket '%s'", path);
	   errno = ENOENT;
	   return(-1);
	}

	len = sizeof(server);
	if (kfile_isread(file))
	{
	   if (connect(sock, (struct sockaddr *) &server, len) == -1)
	   {
	      close(sock);
	      kinfo(KVERBOSE,"socket_connect:  Connect failure for socket '%s'",
			path);
	      return(-1);
	   }
	}
	else
	{
	   if (bind(sock, (struct sockaddr *) &server, len) == -1)
	   {
	      close(sock);
	      kinfo(KVERBOSE,"socket_connect:  Bind failure for socket '%s'",
			path);
	      return(-1);
	   }
	   listen(sock, 1);

	   if ((nsock = accept(sock, (struct sockaddr *) &server, &len)) == -1)
	   {
	      close(sock);
	      kinfo(KVERBOSE,"socket_connect:  Accept failure for socket '%s'",
			path);
	      return(-1);
	   }
	   close(sock);
	   sock = nsock;
	}
	return(sock);
}

#endif  /* KSOCKET_DEF */
/* don`t add after the endif */
