 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgenmanual
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgenmanual.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generates the manual for a toolbox.
|
|       Purpose: main program for kgenmanual
|
|         Input:
|		char *clui_info->tb_string; {toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->i_file; {Input Filename}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output Filename}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kgenmanual_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "kgenmanual",
		kgenmanual_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgenmanual_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
   if (!run_kgenmanual(clui_info->i_file, clui_info->o_file))
   {
      kerror(NULL, "main()",
	     "An Error occured during the generation of the output file\n"
	     "'%s'\nAs a result the output file was not generated\n",
	     clui_info->o_file);
      kexit(KEXIT_FAILURE);
   }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgenmanual_usage_additions
| 
|       Purpose: Prints usage additions in kgenmanual_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenmanual
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenmanual_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerates the manual for a toolbox.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgenmanual_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgenmanual_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenmanual
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgenmanual_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
