 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>  Private:
   >>>>             pane_command()
   >>>>  Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kexec.h"
#include "kforms/kforms.h"
#include "kforms/kformsP.h"


/*-----------------------------------------------------------
|
|  Routine Name: pane_command  - get the pane command
|
|       Purpose: This routine creates a command according to the pane's
|		 form.
|
|         Input: oname     - the object name
|		 toolbox   - the toolbox name
|		 pane_path - the path to the pane to be executed
|		 arguments - the arguments to the pane object
|        Output: 
|       Returns: the resulting command to be executed or NULL on failure
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Feb 25, 1994
| Modifications:
|
------------------------------------------------------------*/

int pane_command(
  char   *tbname,
  char   *oname,
  char   *pane_path,
  char   *arguments,
  char   *command)
{
	int   i, ac;
	kform *pane;
	char  *cmdline, **av;
	char  temp[KLENGTH];
	char  extra_arg[KLENGTH];

	kprog_set_toolbox(tbname);
	kprog_set_program(oname);
	av = kparse_string_delimit(arguments, " ", KDELIM_CLEAN, &ac);
	av = karray_insert(av, oname, ac, KLIST_HEAD, TRUE);
	kprog_set_argc(ac+1); kprog_set_argv(av);

	if ((pane = kgen_initialize(pane_path, KGEN_PANE, 
				     tbname, oname, NULL)) == NULL)
	{
	   return(FALSE);
	}
	cmdline = kvf_form_to_cmd(pane, pane->subform, NULL, TRUE);

	if (!(kclui_consolidate_args(pane)))
              return(NULL);

	kvf_destroy_form(pane);
	ac = kprog_get_argc();
	av = kprog_get_argv();

	ksprintf(temp, cmdline);
	kfree(cmdline);
	if (ac > 1)
	{
	   i = 1;
	   while (i < ac) 
	   {
	      ksprintf(extra_arg, " %s", av[i++]);
	      (void) kstring_cat(temp, extra_arg, temp);
	   }
	}

	kstrcpy(command, temp); 
	return(TRUE);
}
