 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kecho.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kecho_get_args
| 
|       Purpose: Gets command line args for kecho
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kecho
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kecho_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kecho is out of sync with arguments specified in kecho's *.pane file; please rerun ghostwriter on kecho.";


	/*
	 * allocate the kecho structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kecho_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "echo", KVF_TOGGLE_VAL,
			  &(clui_info->echo_toggle),
			  &(clui_info->echo_flag))))
	{
	    kerror(NULL, "kecho_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_flag(pane, "fullpath",
			  &(clui_info->fullpath_flag))))
	{
	    kerror(NULL, "kecho_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kecho_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "type",
			  &(clui_info->type_string),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kecho_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



