
 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/* Copyright (C) 1993 Khoral Research, Inc.   All rights reserved. */
/* See $BOOTSTRAP/repos/copyright/Copyright for terms and conditions. */

#include "copyright.h"		/* Khoros copyright */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Prototypes for kimake
   >>>>
   >>>>    Written By: Tom Sauer
   >>>>
   >>>>          Date: Mar 02, 1993 19:48
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kimakedef_h_
#define _kimakedef_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

#define LENGTH 1024
#define TABLESIZE 1024

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _kilist
{
        int   identifier;
        char *client_data;
        unsigned char head;

        struct _kilist *next, *prev;
} kilist;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/

#define kstring_copy(x,y)       (kstring_3cat(x, NULL, NULL, y))
#define kstring_cat(x,y,z)      (kstring_3cat(x, y, NULL, z))
#define kstrdup(x)              (kstring_3cat(x, NULL, NULL, NULL))
#define kstrlen(x)              (((x) == NULL) ? 0 : strlen(x))
#define kmalloc(x)              (((x) == 0) ? NULL : malloc(x))
#define kcalloc(x,y)            (((x) == 0 || (y) == 0) ? NULL : calloc(x,y))
#define krealloc(x,y)           (((y) == 0) ? NULL : (((x) == NULL) ? malloc(y) : realloc((x),(y))))
#undef kfree
#define kfree(x)                if ((x) != NULL) free(x)
#define kabs(x)                 (((x) < 0) ? (-(x)) : (x))

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


/* kimake.c */
int main PROTO((int, char **));
int showit PROTO((FILE *));
int wrapup PROTO((void));
void catch PROTO((int));
int init PROTO((void));
int AddMakeArg PROTO((char *));
int AddCppArg PROTO((char *));
int SetOpts PROTO((int, char **));
char *FindImakefile PROTO((char *));
void LogFatalI PROTO((char *, int));
void LogFatal PROTO((char *, char *));
int showargs PROTO((char **));
int CheckImakefileC PROTO((char *));
int cppit PROTO((char *, char *, char *, FILE *, char *));
int makeit PROTO((void));
char *CleanCppInput PROTO((char *));
int CleanCppOutput PROTO((FILE *, char *));
int isempty PROTO((char *));
char *ReadLine PROTO((FILE *, char *));
int writetmpfile PROTO((FILE *, char *, int, char *));
char *Emalloc PROTO((int));
void KludgeOutputLine PROTO((char **));
void KludgeResetRule PROTO((void));
char *Strdup PROTO((char *));

char *KReadLine PROTO((FILE *));
char *KProcessLine PROTO((char *));
char *kre_comp PROTO((char *));
int kre_exec PROTO((char *));
int kre_subs PROTO((char *, char *));
int kcpp PROTO((void));
char *SpecExpand PROTO((char *));
char *kstrcpy PROTO((char *, char *));
char *kstrstr PROTO((char *, char *));
kilist *kilist_head PROTO((kilist *));
kilist *kilist_tail PROTO((kilist *));
kilist *kilist_locate PROTO((kilist *, int));
kilist *kilist_add PROTO((kilist *, int, char *));
kilist *kilist_delete PROTO((kilist *, int));
char *kstring_3cat PROTO((char *, char *, char *, char *));
char *kstring_cleanup PROTO((char *, char *));
long khash PROTO((char *, int));
int ktoken_find PROTO((char *, int, int *));
int kstring_to_token PROTO((char *));
char *ktoken_to_string PROTO((int));

#endif /* _kimakedef_h_ */
/* Don't add after this point */
