/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: All local #defines and structures for
   >>>>		       Khoros cfft utilities 
   >>>>
   >>>>    Written By: 
   >>>>
   >>>>          Date: Feb 27, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _klibm_kcfft_h_
#define _klibm_kcfft_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*-------------------------------------*
	|       #typdefs 
	---------------------------------------*/

typedef int integer;
typedef char *address;
typedef short int shortint;
typedef float real;
typedef double doublereal;
typedef struct { real r, i; } complex;
typedef struct { doublereal r, i; } doublecomplex;
typedef long int logical;
typedef short int shortlogical;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* cfft.c */
int ford1_  PROTO((integer *, doublereal *));
int ford2_  PROTO((integer *, doublereal *));
int fr2tr_  PROTO((integer *, doublereal *, doublereal *));
int fr4tr_  PROTO((integer *, integer *, doublereal *, 
		   doublereal *, doublereal *, doublereal *, doublereal *,
		   doublereal *, doublereal *, doublereal *));
int fr4syn_ PROTO((integer *, integer *, doublereal *, 
		   doublereal *, doublereal *, doublereal *, doublereal *,
		   doublereal *, doublereal *, doublereal *));
int r2tx_   PROTO((integer *, doublereal *, doublereal *, 
		   doublereal *, doublereal *));
int r4tx_   PROTO((integer *, doublereal *, doublereal *, 
		   doublereal *, doublereal *, doublereal *, doublereal *, 
		   doublereal *, doublereal *));
int r8tx_   PROTO((integer *, integer *, integer *,
		   doublereal *, doublereal *, doublereal *, doublereal *, 
		   doublereal *, doublereal *, doublereal *, doublereal *, 
		   doublereal *, doublereal *, doublereal *, doublereal *, 
		   doublereal *, doublereal *, doublereal *, doublereal *));
int fft842_ PROTO((integer *, integer *, doublereal *, doublereal *));
#endif /* _klibm_kcfft_h_ */
/* Don't add after this point */
