/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>       Purpose: All #defines, structures, and global      <<<<
   >>>>                definitions and routine declarations      <<<<
   >>>>                used by the kforms library                <<<<
   >>>>                                                          <<<<
   >>>>    Written By: Danielle Argiro                           <<<<
   >>>>                                                          <<<<
   >>>>          Date: March 29, 1993                            <<<<
   >>>>                                                          <<<<
   >>>> Modifications: 
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kforms_kforms_h_
#define _kforms_kforms_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <kforms/uislineinfo.h>
#include <kforms/kformsP.h>


        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*
 * #defines for xvfstruct
 */
#define KFORM      1
#define KSUBFORM   2
#define KGUIDE     3
#define KCONTROL   4
#define KSELECTION 5
#define KMASTER    6
#define KGUIDEPANE 7
#define KPANE      8

#define Formptr     u.formptr
#define Subformptr  u.subformptr
#define Guideptr    u.guideptr
#define Controlptr  u.controlptr
#define Selptr      u.selptr

/*
 * #defines for error checking
 */
#define KVF_CLUI 1
#define KVF_GUI  2

/*
 * #defines for glyphs
 */

#define         ICON            -1
#define         SIMPLE           1

/*
 * #defines for GUI/UIS attributes
 */
#define KVF_ACTIVATE 		"forms_activate"
#define KVF_SELECTED 		"forms_selected"
#define KVF_OPTIONAL 		"forms_optional"
#define KVF_OPTSEL 		"forms_optsel"
#define KVF_LIVE 		"forms_live"
#define KVF_VARIABLE 		"forms_variable"
#define KVF_DESCRIPTION 	"forms_description"
#define KVF_TITLE		"forms_title"
#define KVF_BUTTONTITLE		"forms_buttontitle"
#define KVF_GUIDEPANETITLE	"forms_guidepanetitle"
#define KVF_LITERAL		"forms_literal"
#define KVF_MODIFIED		"forms_modified"
#define KVF_WIDTH		"forms_width"
#define KVF_HEIGHT		"forms_height"
#define KVF_X			"forms_x"
#define KVF_Y			"forms_y"
#define KVF_BUTTONWIDTH		"forms_buttonwidth"
#define KVF_BUTTONHEIGHT	"forms_buttonheight"
#define KVF_BUTTONX		"forms_buttonx"
#define KVF_BUTTONY		"forms_buttony"
#define KVF_XPOS		"forms_xpos"
#define KVF_YPOS		"forms_ypos"
#define KVF_WORKSPACE		"forms_workspace"
#define KVF_CLIENTDATA 		"forms_clientdata"

#define KVF_DELETE              "forms_delete"
#define KVF_DISPLAY_SUBFORM     "forms_display_subform"
#define KVF_DISPLAY_PANE        "forms_display_pane"

#define KVF_PRINT_UIS		"forms_print_uis"
#define KVF_PRINT_PANE		"forms_print_pane"
#define KVF_PRINT_SUBFORM	"forms_print_subform"

#define KVF_UIS_LOCATION	"forms_uis_location"
#define KVF_PANE_FILE		"forms_pane_file"
#define KVF_SUBFORM_FILE	"forms_subform_file"

#define KVF_ME_SUBFORMS		"forms_me_subforms"

#define KVF_FILE_NAME 		"forms_file_name"
#define KVF_FILE_CHECK   	"forms_file_check"
#define KVF_FILE_DEF 		"forms_file_def"
#define KVF_STRING_VAL 		"forms_string_val"
#define KVF_STRING_DEF 		"forms_string_def"
#define KVF_STRING_MULTILINE 	"forms_string_multiline"

#define KVF_EXECTYPE 		"forms_exectype"
#define KVF_ROUTINE 		"forms_routine"
#define KVF_HELPPATH 		"forms_help_path"

#define KVF_TOGGLE_SIZE 	"forms_toggle_size"
#define KVF_TOGGLE_MEMBERS  	"forms_toggle_members"
#define KVF_TOGGLE_NUM 		"forms_toggle_num"
#define KVF_TOGGLE_VAL 		"forms_toggle_val"
#define KVF_TOGGLE_TYPE 	"forms_toggle_type"
#define KVF_TOGGLE_CONTENTS 	"forms_toggle_contents"
#define KVF_TOGGLE_CONTENTS_DESC "forms_toggle_contents_desc"

#define KVF_LOGIC_VAL 		"forms_logic_val"
#define KVF_LOGIC_DEF 		"forms_logic_def"
#define KVF_LOGIC_1LABEL 	"forms_logic_1label"
#define KVF_LOGIC_0LABEL 	"forms_logic_0label"
#define KVF_LOGIC_LABEL 	"forms_logic_label"

#define KVF_LIST_SIZE 		"forms_list_size"
#define KVF_LIST_VAL 		"forms_list_val"
#define KVF_LIST_ITEM 		"forms_list_item"
#define KVF_LIST_LABEL 		"forms_list_label"
#define KVF_LIST_INDEX 		"forms_list_index"
#define KVF_LIST_START 		"forms_list_start"
#define KVF_LIST_CONTENTS 	"forms_list_contents"
#define KVF_LIST_CHOICES 	"forms_list_choices"
#define KVF_LIST_DOUBLECLICK 	"forms_list_doubleclick"
#define KVF_LIST_ADD 	        "forms_list_add"
#define KVF_LIST_DELETE 	"forms_list_delete"
#define KVF_LIST_DELETEALL 	"forms_list_deleteall"
#define KVF_VAL_LABELS     	"forms_val_labels"

#define KVF_CYCLE_SIZE          "forms_list_size"
#define KVF_CYCLE_VAL           "forms_list_val"
#define KVF_CYCLE_LABEL         "forms_list_label"
#define KVF_CYCLE_INDEX         "forms_list_index"
#define KVF_CYCLE_START         "forms_list_start"
#define KVF_CYCLE_CHOICES       "forms_list_choices"
#define KVF_CYCLE_CONTENTS      "forms_list_contents"
#define KVF_CYCLE_ADD           "forms_list_add"
#define KVF_CYCLE_DELETE        "forms_list_delete"
#define KVF_CYCLE_DELETEALL     "forms_list_deleteall"

#define KVF_INT_GT0_SEL         "forms_int_gt0_sel"
#define KVF_INT_GE0_SEL         "forms_int_ge0_sel"
#define KVF_INT_LT0_SEL         "forms_int_lt0_sel"
#define KVF_INT_LE0_SEL         "forms_int_le0_sel"
#define KVF_INT_UPPER_SEL 	"forms_int_upper_sel"
#define KVF_INT_LOWER_SEL	"forms_int_lower_sel"
#define KVF_INT_BOUNDS_SEL      "forms_int_bounds_sel"
#define KVF_INT_NOBOUNDS_SEL    "forms_int_nobounds_sel"
#define KVF_INT_UPPER 		"forms_int_upper"
#define KVF_INT_LOWER 		"forms_int_lower"
#define KVF_INT_DEF		"forms_int_def"
#define KVF_INT_VAL		"forms_int_val"
#define KVF_MECHANISM		"forms_mechanism"

#define KVF_FLOAT_GT0_SEL       "forms_float_gt0_sel"
#define KVF_FLOAT_GE0_SEL       "forms_float_ge0_sel"
#define KVF_FLOAT_LT0_SEL       "forms_float_lt0_sel"
#define KVF_FLOAT_LE0_SEL       "forms_float_le0_sel"
#define KVF_FLOAT_UPPER_SEL     "forms_float_upper_sel"
#define KVF_FLOAT_LOWER_SEL     "forms_float_lower_sel"
#define KVF_FLOAT_BOUNDS_SEL    "forms_float_bounds_sel"
#define KVF_FLOAT_NOBOUNDS_SEL  "forms_float_nobounds_sel"
#define KVF_FLOAT_UPPER 	"forms_float_upper"
#define KVF_FLOAT_LOWER 	"forms_float_lower"
#define KVF_FLOAT_DEF		"forms_float_def"
#define KVF_FLOAT_VAL		"forms_float_val"
#define KVF_FLOAT_PREC		"forms_float_prec"

#define KVF_DOUBLE_GT0_SEL      "forms_double_gt0_sel"
#define KVF_DOUBLE_GE0_SEL      "forms_double_ge0_sel"
#define KVF_DOUBLE_LT0_SEL      "forms_double_lt0_sel"
#define KVF_DOUBLE_LE0_SEL      "forms_double_le0_sel"
#define KVF_DOUBLE_UPPER_SEL    "forms_double_upper_sel"
#define KVF_DOUBLE_LOWER_SEL    "forms_double_lower_sel"
#define KVF_DOUBLE_BOUNDS_SEL   "forms_double_bounds_sel"
#define KVF_DOUBLE_NOBOUNDS_SEL "forms_double_nobounds_sel"
#define KVF_DOUBLE_UPPER 	"forms_double_upper"
#define KVF_DOUBLE_LOWER 	"forms_double_lower"
#define KVF_DOUBLE_DEF		"forms_double_def"
#define KVF_DOUBLE_VAL		"forms_double_val"
#define KVF_DOUBLE_PREC		"forms_double_prec"


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

/************************************************************
*
*  Routine Name: kvf_set_attribute - sets a single attribute for a form tree node (where no xvobjects have been created)
*
*       Purpose: sets a single attribute for a kformstruct
*
*         Input: kformstruct - GUI item for which to set the attribute
*                attribute   - the attribute name
*                value       - the attribute value
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Value provided must be of the expected data type
*    Written By: Mark Young & Danielle Argiro
*          Date: March 22, 1994
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: kvf_set_attribute(
*                !   kform_struct kformstruct,
*                !   char         *attribute,
*                !   data         value)
*
*************************************************************/

#define kvf_set_attribute(kformstruct, attribute, value) \
                kvf_set_attributes(kformstruct, attribute, value, NULL)


/************************************************************
*
*  Routine Name: kvf_get_attribute - gets a single attribute for a form tree node (where no xvobjects have been created)
*
*       Purpose: gets a single attribute for a kformstruct
*
*         Input: kformstruct - GUI item for which to get the attribute
*                attribute   - the attribute name
*                value       - pointer to the the attribute value
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Value pointer passed in must be of the expected data type
*    Written By: Mark Young & Danielle Argiro
*          Date: Feb 1, 1994
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: kvf_get_attribute(
*                !   kform_struct kformstruct,
*                !   char         *attribute,
*                !   data         *value)
*
*************************************************************/

#define kvf_get_attribute(kformstruct, attribute, value) \
                kvf_get_attributes(kformstruct, attribute, value, NULL)



        /*-------------------------------------*
        |     public routine definitions
        ---------------------------------------*/
/* 
 *  attributes.c 
 */
int kvf_set_attributes PROTO((kform_struct *, kvalist));
int kvf_get_attributes PROTO((kform_struct *, kvalist));

/*
 *  command.c
 */
char *kvf_form_to_cmd          PROTO((kform *, ksubform *, char *, int));
int   kvf_modify_form_from_cmd PROTO((kform *, char *, int));

/*
 * createtree.c
 */
kform *kvf_create_form PROTO((char *, int, kfunc_void, kaddr));

/*
 *  destroy.c
 */
void kvf_destroy_form PROTO((kform *));

/*
 * utilities.c
 */
int kvf_check_for_single_pane  PROTO((kform *, char *));
int kvf_gui_item_exists        PROTO((kselection *, int));
kselection *kvf_gui_named_item_exists  PROTO((kselection *, int, int));

int kvf_append_selections      PROTO((kform *, char *));

#endif /* _kforms_kforms_h_ */
/* Don't add after this line */
