/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Public definitions relating to toolbox object
   >>>>
   >>>>    Written By: Steven Jorgensen
   >>>>
   >>>>          Date: 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_tbobj_h_
#define _kcms_tbobj_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/*-----------------------------------------------------------------------
| bit flags for the KCMS_TB_FLAGS attribute
-----------------------------------------------------------------------*/

#define KCMS_BIT_TB_FORCE		(1L << 0)


#define KCMS_TB_OFFSET		  	400
#define KCMS_TB_MAX		  	25

/*-- attributes that represent characteristics of a object ------------*/
#define KCMS_TB_NAME              	KCMS_NAME
					    /* KCMS_TYPE is #2 */
#define KCMS_TB_PATH              	KCMS_PATH
					    /* KCMS_PARENT is #4 */
                                            /* KCMS_DATE is #5 */

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_SOFTWARE_OBJECTS
| Type:		klist *
| List Type:	kobject
| Description:	The list of software objects within a toolbox.  The client
|		data associated with each item of the list is a kobject
|		for a software object; the identifier of the list is the
|		software object's name.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_SOFTWARE_OBJECTS	6

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_CATEGORYINFO
| Type:		foo
| Description:	Category information for all software objects in the
|		toolbox.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_CATEGORYINFO		7

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_MISC_FILES
| Type:		klist *
| List Type:	kobject
| Description:	The list of file objects for the
|		miscellaneous files associated with a toolbox.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_MISC_FILES		8

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_AUTHOR_EMAIL
| Type:		kstring
| Description:	The contact email address for the toolbox.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_AUTHOR_EMAIL		9

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_AUTHOR
| Type:		kstring
| Description:	The full name of a contact person with a toolbox.
|		This will typically
|		be the full name of the person whose email address is
|		specified with the
|		.symbol - KCMS_TB_AUTHOR_EMAIL
|		attribute.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_AUTHOR			10

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_TITLE
| Type:		kstring
| Description:	A title string associated with the toolbox.
|		toolbox.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_TITLE			11

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_INFO_FILE
| Type:		kobject
| Description:	A file object for the toolbox's info file.  This is a
|		file containing information about the toolbox,
|		its contents, and intended purpose.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_INFO_FILE		12

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_APP_DEFAULTS
| Type:		klist *
| List Type:	kobject
| Description:	A list of file objects which contain
|		app-defaults for the toolbox.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_APP_DEFAULTS		13

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_FLAGS
| Type:		unsigned long
| Description:	Bit flags associated with the toolbox.
| Access:	read/write
| Persistence:	transient
------------------------------------------------------------------------*/
#define KCMS_TB_FLAGS			14

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_STATUS
| Type:		kstring
| Description:	This attribute holds the status of a toolbox, which can
|		be one of four values.
| Legal Values:	KCMS_STATUS_SCRATCH
|		KCMS_STATUS_WORK
|		KCMS_STATUS_DEVELOPMENT
|		KCMS_STATUS_PRODUCTION
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_STATUS			15

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_UPDATE_FLAG
| Type:		unsigned long
| Description:	A flag which specifies whether
|		the toolbox needs to be sync'd to disk.
|		You should not need to set this attribute explicitly,
|		since kcms operations which modify a toolbox
|		update this attribute.
| Legal Values:	KCMS_UPDATE_NONE
|		KCMS_UPDATE_SYNC
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_UPDATE_FLAG		16

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_COPYRIGHT_SHORT
| Type:		kstring
| Description:	The short copyright string to use for software objects
|		within a toolbox.  This should be one line.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_COPYRIGHT_SHORT		17

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_COPYRIGHT_LONG
| Type:		kstring
| Description:	The long copyright statement to use for software objects
|		within a toolbox.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_COPYRIGHT_LONG		18

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_KEYWORDS
| Type:		klist *
| List Type:	kstring
| Description:	A list of keywords associated with the toolbox.
|		The functions
|		.symbol index kcms_add_keyword()
|		and
|		.symbol index kcms_remove_keyword()
|		provide a simple interface to this attribute.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_KEYWORDS		19

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_CONFIG_FILE
| Type:		kobject
| Description:	A file object for the toolbox imake configuration file,
|		<toolbox>.def
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_CONFIG_FILE		20

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_INCLUDE_FILE
| Type:		kobject
| Description:	A file object for the toolbox include file, <toolbox>.h
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_INCLUDE_FILE		21

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_VERSION
| Type:		kstring
| Description:	A string which holds the toolbox version.  This should be
|		a three-tuple of the form: <release>.<major>.<minor>,
|		for example: 2.0.0.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_VERSION			22

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_ALIAS_FILE
| Type:		kobject
| Description:	A file object for the toolbox alias file, which lives in
|		$TOOLBOX/repos/Aliases by default.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_ALIAS_FILE		23

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_TODO_FILE
| Type:		kobject
| Description:	A file object for the toolbox's todo file.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_TODO_FILE		24

/*------------------------------------------------------------------------
| Attribute:	KCMS_TB_CHANGELOG_FILE
| Type:		kobject
| Description:	A file object for the toolbox's changelog file.
| Access:	read/write
| Persistence:	stored
------------------------------------------------------------------------*/
#define KCMS_TB_CHANGELOG_FILE		25


/*-- preprocessor symbols for toolbox status (attribute KCMS_TB_STATUS) --*/

#define KCMS_STATUS_SCRATCH	0
#define KCMS_STATUS_WORK	1
#define KCMS_STATUS_DEVELOPMENT	2
#define KCMS_STATUS_PRODUCTION	3

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _kcms_tbobj_h_ */
/* Don't add after this point */
