#include <bootstrap.h>

static klist  *category_contents = NULL;
static klist  *toolbox_contents = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: category_sort
|
|       Purpose: Sort by category/subcategory/toolboxes/objects
|
|         Input: token1 - the first string token to be sorted
|                token2 - the second string token to be sorted
|       Returns: TRUE on success, FALSE on failure
|    Written By: Mark Young
|          Date: Dec 02, 1993
|
------------------------------------------------------------*/
/*ARGSUSED*/
static int category_sort(
   kaddr token1,
   kaddr token2)
{
        return(kstrcmp(ktoken_to_string((int) token1),
                       ktoken_to_string((int) token2)));
}

/*-----------------------------------------------------------
|
|  Routine Name: add_entry
|
|       Purpose: adds an entry into the category/toolbox lists.
|
|         Input: info - the info array to be added
|       Returns: 
|    Written By: Mark Young
|          Date: Nov 30, 1994
|
------------------------------------------------------------*/
/*ARGSUSED*/
static void add_content_entry(
   char *toolbox,
   char *program,
   char *category,
   char *subcategory,
   char *iconname,
   char *panefile,
   char *workspace,
   char *description)
{
	char  **info = NULL;
	int   category_token, subcategory_token, iconname_token,
	      tbname_token, oname_token;
	klist *category_list, *subcategory_list, *iconname_list,
	      *tbname_list, *oname_list;


	/*
	 *  Create a token for each of the strings
	 */
        iconname_token    = kstring_to_token(iconname);
        tbname_token      = kstring_to_token(toolbox);
        oname_token       = kstring_to_token(program);
        category_token    = kstring_to_token(category);
        subcategory_token = kstring_to_token(subcategory);
	if (kstrcmp(category, "(NULL)") == 0)
	{
	   kwarn("xvlang", "add_content_entry",
		     "Warning: toolbox %s has a NULL category", toolbox);
	}

	/*
	 *  Create the info structure
	 */
	info = karray_insert(info, ktoken_to_string(iconname_token), 0,
				KLIST_TAIL, TRUE);
	info = karray_insert(info, ktoken_to_string(tbname_token), 1,
				KLIST_TAIL, TRUE);
	info = karray_insert(info, ktoken_to_string(oname_token), 2,
				KLIST_TAIL, TRUE);
	info = karray_insert(info, ktoken_to_string(category_token), 3,
				KLIST_TAIL, TRUE);
	info = karray_insert(info, ktoken_to_string(subcategory_token), 4,
				KLIST_TAIL, TRUE);
	info = karray_insert(info, kstrdup(panefile), 5, KLIST_TAIL, TRUE);
	info = karray_insert(info, kstrdup(workspace), 6, KLIST_TAIL, TRUE);
	info = karray_insert(info, kstrdup(description), 7, KLIST_TAIL, TRUE);

	/*
	 *  Add the category/subcategory/iconname
	 */
	category_list = klist_locate(category_contents, (kaddr) category_token);
	subcategory_list = (klist *) klist_clientdata(category_list);
	subcategory_list = klist_locate(subcategory_list,
				(kaddr)subcategory_token);
	iconname_list  = (klist *) klist_clientdata(subcategory_list);
	iconname_list  = klist_locate(iconname_list, (kaddr) iconname_token);
	iconname_list  = klist_add((klist *) klist_clientdata(subcategory_list),
				(kaddr) iconname_token, info);
	subcategory_list = klist_add((klist *) klist_clientdata(category_list),
				(kaddr) subcategory_token, iconname_list);
	category_contents = klist_add(category_contents,
				(kaddr) category_token, subcategory_list);

	/*
	 *  Add the toolbox/object list
	 */
	tbname_list = klist_locate(toolbox_contents, (kaddr) tbname_token);
	oname_list  = (klist *) klist_clientdata(tbname_list);
	oname_list  = klist_locate(oname_list, (kaddr) oname_token);
	oname_list  = klist_add((klist *) klist_clientdata(tbname_list),
				(kaddr) oname_token, info);
	toolbox_contents = klist_add(toolbox_contents,
				(kaddr) tbname_token,oname_list);
}

/*-----------------------------------------------------------
|
|  Routine Name: init_list_contents
|
|       Purpose: Gets the information that describes how the 
|                main cantata form should look. Store it as follows
|                using klist utilities:
|
|		 category -----> category ----> category
|                   |
|                   V 
|                 subcategory --> subcategory --> subcategory
|		    |               
|                   V
|		  *.pane file --> *.pane file --> *.pane file
|
|       Returns: Returns the header of the category list.
|    Written By: Danielle Argiro & Mark Young
|          Date: Nov 20, 1993
|
------------------------------------------------------------*/
/*ARGSUSED*/
static void init_list_contents(void)
{
	kobject toolbox;
	klist   *category, *subcategory, *iconname, *tbname, *oname;

	int  i, j, status, num, tb_num, *incantata;
	char **toolboxes, **programs, **name, **categories, **subcategories,
	     **panefiles, **workspaces, **descriptions;


	kannounce("bootstrap", "init_list_contents", "Reading menus for all \
toolboxes.");
	/*
         *  Get array of toolbox names
         */
	if (!(toolboxes = kcms_query_toolboxes(&tb_num)))
	{
	    kinfo(KSTANDARD, "Warning: No toolboxes accessable via cantata");
	    return;
	}

	/*
	 *  Must preserve the head of the list
	 */
	for (i = 0; i < tb_num; i++)
        {
	   if (!(toolbox = kcms_open_toolbox(toolboxes[i])))
           {
              kwarn("xvlang", "init_list_contents",
		    "Warning: Cannot open toolbox object '%s'\n", toolboxes[i]);
	      continue;
           }

	   /*
	    *  get the status of the toolbox
	    */
	   if (!kcms_get_attribute(toolbox, KCMS_TB_STATUS, &status) ||
		status != KCMS_STATUS_DEVELOPMENT &&
	        status != KCMS_STATUS_PRODUCTION)
	   {
	      kcms_close(toolbox);
	      continue;
	   }
	   kannounce("bootstrap", "init_list_contents",
		"Reading menus for toolbox '%s'", toolboxes[i]);

	   kcms_get_attribute(toolbox, KCMS_TB_CATEGORYINFO, &programs,
			       NULL, &name, &categories, &subcategories,
			       &panefiles, &workspaces, &incantata,
			       &descriptions, &num);

	   for (j = 0; j < num; j++)
	   {
	      if (!incantata[j])
		 continue;

	      add_content_entry(toolboxes[i], programs[j], categories[j],
				subcategories[j], name[j], panefiles[j],
				workspaces[j], descriptions[j]);
	    }
	    kcms_close(toolbox);
        }

	/*
	 *  Do the nasty sort thing for the category/subcategory/iconname
	 *  list...
	 */
	category_contents = klist_sort(category_contents, category_sort, TRUE);
	category = category_contents;
	while (category != NULL)
	{
	    subcategory = klist_sort((klist *) category->client_data,
				category_sort, TRUE);
	    category->client_data = (kaddr) subcategory;

	    while (subcategory != NULL)
	    {
	       iconname = (klist *) subcategory->client_data;
	       if (klist_next(iconname) != NULL)
		  iconname = klist_sort(iconname, category_sort, TRUE);

	       subcategory->client_data = (kaddr) iconname;
	       subcategory = klist_next(subcategory);
	    }
	    category = klist_next(category);
	}

	/*
	 *  Do the nasty sort thing for the toolbox/object name list...
	 */
	toolbox_contents = klist_sort(toolbox_contents, category_sort, TRUE);
	tbname = toolbox_contents;
	while (tbname != NULL)
	{
	    oname = klist_sort((klist *) tbname->client_data,
				category_sort, TRUE);
	    tbname->client_data = (kaddr) oname;
	    tbname = klist_next(tbname);
	}
	karray_free(toolboxes, tb_num, NULL);
	kannounce("bootstrap", "init_list_contents", "Done reading menus.");
}

/*-----------------------------------------------------------
|
|  Routine Name: free_list_contents
|
|       Purpose: Frees the contents of the tri-linked data structure 
|         Input: category_list - head of category list
|        Output:
|       Returns: 
|    Written By: Danielle Argiro & Mark Young
|          Date: Nov 20, 1993 
| Modifications:
|
------------------------------------------------------------*/
/*ARGSUSED*/
void free_list_contents(void)
{
	klist *category, *subcategory, *iconname, *tbname, *oname;

 	category = category_contents;
	while (category != NULL)
	{
	    subcategory = (klist *) category->client_data;
	    while (subcategory != NULL)
	    {
    	    	iconname = (klist *) subcategory->client_data;
    		klist_free(iconname, NULL);
		subcategory = klist_next(subcategory);
	    }
	    subcategory = (klist *) category->client_data;
	    klist_free(subcategory, NULL);
	    category = klist_next(category);
	}
	klist_free(category_contents, NULL);
	category_contents = NULL;

 	tbname = toolbox_contents;
	while (tbname != NULL)
	{
	    oname = (klist *) tbname->client_data;
	    klist_free(oname, NULL);
	    tbname = klist_next(tbname);
	}
	klist_free(toolbox_contents,  NULL);
	toolbox_contents  = NULL;
}

/*-----------------------------------------------------------
|
|  Routine Name: print_list_contents
|
|       Purpose: Prints the contents of the tri-linked data structure
|         Input: category_head - head of category list
|        Output:
|       Returns:
|    Written By: Danielle Argiro
|          Date: Mar 10, 1993
| Modifications:
|
------------------------------------------------------------*/
 
static void print_list_contents(
    klist *category_head)
{
        klist *catlist, *sublist, *panelist;
        char  **info, *category, *subcategory, *panefile, temp[KLENGTH],
              type[KLENGTH];
 
        kfprintf(kstderr, "\n\n");
        kfprintf(kstderr, "--- internal list contents --- \n");
        catlist = category_head;
        while (catlist != NULL)
        {
            category = ktoken_to_string((int) catlist->identifier);
            sublist = (klist *) catlist->client_data;
            while (sublist != NULL)
            {
                subcategory = ktoken_to_string((int) sublist->identifier);
                panelist = (klist *) sublist->client_data;
                while (panelist != NULL)
                {
                    info = (char **) klist_clientdata(panelist);
                    panefile = info[5];
                    kdirname(panefile, temp);
                    kdirname(temp, temp);
                    kdirname(temp, temp);
                    kbasename(temp, type);
                    kfprintf(kstderr, "%s:%s:%s:%s:%s:%s\n", category,
                        subcategory, info[0], info[1], info[2], type);
                    panelist = klist_next(panelist);
                }
                sublist = klist_next(sublist);
            }
            catlist = klist_next(catlist);
        }
}

/*
 *  list example in order to test building a linked list of all the toolbox
 *  information.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "BOOTSTRAP");

        init_list_contents();
        print_list_contents(category_contents);
}
