/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_VOICE_H__
#define __BSE_VOICE_H__

#include	<bse/bseinstrument.h>
#include	<bse/bseeffects.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */




struct _BseVoice
{
  BseNote	*note;
  BseNote	*next_note;
  guint		volume;
  gint		balance;
  
  guint16	channel_index	/* ??? */;
  guint		active : 1;

  /* private sample mixer fields */
  guint		  sample_munk_index /* BseMunk* */;
  guint32	  sample_rate;
  guint32	  sample_rate_offset /* fine tunes */;
  guint		  sample_pos_frac;
  BseSampleValue *sample_pos;
  BseSampleValue *sample_end_pos;
  BseInstrument	 *last_instrument;
  BseSample	 *last_sample;
  guint		  last_volume;


  /* envelope generator specific fields */
  guint		envelope_switch;
  guint		envelope_volume;

  /* lfo specific fields */
  BseLfo	*lfo;
};


/* --- prototypes --- */
BseVoice*	bse_voice_block_alloc			(guint		n_voices);
void		bse_voice_reset				(BseVoice	*voice);
void		bse_voice_block_free			(BseVoice	*voices);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_VOICE_H__ */
