/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_MAIN_H__
#define __BSE_MAIN_H__

#include	<bse/bsebase.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- defines --- */
#define	BSE_MAIN_KEEP_ALIVE()	G_STMT_START { \
  if (bse_main_need_iteration ()) \
    bse_main_iteration (); \
} G_STMT_END


/* --- prototypes --- */
void		bse_main_play_song		(BseSong	*song);
void		bse_main_play_song_with_ticks	(BseSong	*song,
						 BseSequencerTickCB callback,
						 gpointer	 callback_data);
void		bse_main_quit_song		(BseSong	*song);
void		bse_main_suspend		(BseSong	*song);
void		bse_main_continue		(BseSong	*song);
void		bse_main_add_output_stream	(BseStream	*stream);
void		bse_main_remove_output_stream	(BseStream	*stream);

/* do actual buffer calculation
 */
void		bse_main_iteration		(void);

/* is buffer calculation required?
 */
gboolean	bse_main_need_iteration		(void);

/* is there any possibility bse would block in bse_main_iteration ()?
 */
gboolean	bse_main_can_block		(void);

/* trigger tick callbacks
 */
void		bse_main_trigger_ticks		(void);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_MAIN_H__ */
