/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_SONG_SHELL_H__
#define __BST_SONG_SHELL_H__

#include	<bse/bse.h>
#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


#define	BST_TYPE_SONG_SHELL		(bst_song_shell_get_type ())
#define	BST_SONG_SHELL(object)		(GTK_CHECK_CAST ((object), BST_TYPE_SONG_SHELL, BstSongShell))
#define	BST_SONG_SHELL_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), BST_TYPE_SONG_SHELL, BstSongShellClass))
#define	BST_IS_SONG_SHELL(object)	(GTK_CHECK_TYPE ((object), BST_TYPE_SONG_SHELL))
#define	BST_IS_SONG_SHELL_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), BST_TYPE_SONG_SHELL))


typedef	struct	_BstSongShell		BstSongShell;
typedef	struct	_BstSongShellClass	BstSongShellClass;


struct	_BstSongShell
{
  GtkWindow	window;

  GtkObject	*menubar_factory;

  BseSong	*song;
  guint		current_pattern_guid;

  guint		is_playing : 1;

  GList		*pview_list;

  GtkWidget	*name_entry;
  GtkWidget	*play_button;
  GtkWidget	*play_indicator;
  GtkWidget	*stop_button;
  GtkAdjustment	*adj_bpm;
  GtkAdjustment	*adj_volume;
  GtkWidget	*pattern_clist;

  BsePattern	*last_pattern;
  guint		last_row;

  /* dialogs
   */
  GtkWidget	*pattern_list;
  GtkWidget	*instrument_editor;
};

struct	_BstSongShellClass
{
  GtkWindowClass	parent_class;

  gchar			*factories_path;
  GtkObject		*pview_popup_factory;

  void	(*test_signal)	(void);
};

/* song shell class actions of bst_song_shell_class_operation()
 */
typedef enum
{
  BST_SONG_SHELL_CLASS_OP_NONE,

  /* pattern operations
   */
  BST_SONG_SHELL_CLASS_OP_PATTERN_NEW,
  BST_SONG_SHELL_CLASS_OP_PATTERN_VIEW,

  BST_SONG_SHELL_CLASS_OP_LAST
} BstSongShellClassOps;

/* song shell actions of bst_song_shell_operation()
 */
typedef enum
{
  BST_SONG_SHELL_OP_NONE,

  /* song operations
   */
  BST_SONG_SHELL_OP_SONG_SAVE,
  BST_SONG_SHELL_OP_SONG_SAVE_AS,
  BST_SONG_SHELL_OP_SONG_CLOSE,

  /* Dialogs
   */
  BST_SONG_SHELL_OP_PATTERN_LIST,
  BST_SONG_SHELL_OP_INSTRUMENT_LIST,

  /* actions forwarded to BstShell
   */
  BST_SONG_SHELL_OP_SHELL_NEW,
  BST_SONG_SHELL_OP_SHELL_OPEN,
  BST_SONG_SHELL_OP_SHELL_PREFERENCES,
  BST_SONG_SHELL_OP_SHELL_QUIT,
  BST_SONG_SHELL_OP_SHELL_ABOUT,

  /* misc
   */
  BST_SONG_SHELL_OP_DELETE,

  BST_SONG_SHELL_OP_LAST
} BstSongShellOps;

GtkType		bst_song_shell_get_type		(void);
GtkWidget*	bst_song_shell_new		(BseSong	*song);
void		bst_song_shell_update		(BstSongShell	*song_shell);
void		bst_song_shell_sequencer_tick	(BstSongShell	*song_shell);
void		bst_song_shell_pla_do		(BstSongShell	*song_shell,
						 guint		pla);
GtkWidget*	bst_song_shell_new_pattern_view	(BstSongShell	*song_shell,
						 guint		 pattern_guid);
void		bst_song_shell_play_start	(BstSongShell	*song_shell);
void		bst_song_shell_play_stop	(BstSongShell	*song_shell);
BstSongShell*	bst_song_shell_from_song	(BseSong	*song);
void		bst_song_shell_operation	(BstSongShell	*song_shell,
						 BstSongShellOps ss_op);
void		bst_song_shell_clop		(BstSongShellClass   *klass,
						 BstSongShellClassOps ssc_op);

     



#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BST_SONG_SHELL_H__ */
