.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvInqBackgroundColor 3D  "Dore"
.SH NAME
DvInqBackgroundColor \- Return the background color of a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvInqBackgroundColor(view, colormodel, color)
DtObject view;
DtColorModel colormodel;
DtReal color[\|];
.sp
.in -.5i
.sp
FORTRAN:
.in +.5i
CALL DVQBC(VIEW, COLMOD, COLOR)
INTEGER*4 VIEW 
INTEGER*4 COLMOD 
REAL*8 COLOR(*) 
.in -.5i
.fi
.SH DESCRIPTION
.IX DVQBC
.IX DvInqBackgroundColor
.I DvInqBackgroundColor
queries the background color of the view specified by the parameter \f2view\fP.
The parameter \f2colormodel\fP specifies the color model expected.
The parameter \f2color\fP
returns the color to which a view is cleared when the view's clear flag is
set and the view is updated.
.SH ERRORS
.I DvInqBackgroundColor
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH "SEE ALSO"
DvSetBackgroundColor(3D)
