.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsValuatorSwitch 3D  "Dore"
.SH NAME
DsValuatorSwitch \- Enable or disable valuators
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsValuatorSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSVS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DSVS
.IX DsValuatorSwitch
.I DsValuatorSwitch
sets the system valuator switch.
The parameter \f2switchvalue\fP specifies whether
valuator callbacks are currently allowed to execute.
.PP
A valuator is a callback object that depends on input slots.  Input
slots are entry
points for \f2DtReal <REAL*8>\fP type values.  These input slots are the primary
interface for connecting input events and values to Dor\o.\(aae..
.PP
When the value of the valuator switch is \f2DcOff\fP <\f2DCOFF\fP>, all inputs
through input slots are blocked.  When the value of the valuator switch is
\f2DcOn\fP <\f2DCON\fP>, all blocked inputs are flushed.  This mechanism allows
applications to edit the database
without worrying about simultaneous editing by valuators responding to
external events.
.SH DEFAULTS
The default \f2DsValuatorSwitch\fP is \f2DcOn\fP <\f2DCON\fP>.
.SH "SEE ALSO"
.na
.nh
DoCallback(3D), DoInputSlot(3D), DsInputValue(3D), DsInqValuatorGroup(3D)
.ad
.hy
