.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqObjClassId 3D  "Dore"
.SH NAME
DsInqObjClassId \- Return an object's class id from its object handle
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtInt DsInqObjClassId(object)
DtObject object;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DSQOCI(OBJECT)
INTEGER*4 OBJECT
.in -.5i
.fi
.SH DESCRIPTION
.IX DSQOCI
.IX DsInqObjClassId
.I DsInqObjClassId
finds an object's class id given its object handle.
The parameter \f2object\fP specifies the object.
.PP
When an object is created, it is assigned a class that is 
identifiable by both an integer class identification number and a class name.  
The class identifier can be determined from an object's 
handle using \f2DsInqObjClassId\f1, or from the class 
name using \f2DsInqClassId\fP <\f2DSQCI\fP>.
By convention, the class name is the C Language name of the routine 
used to create an object of that class; for example, an object 
created with \f2DoPolygon\f1 is of class \*(lqDoPolygon\*(rq.  
.SH ERRORS
.I DsInqObjClassId
will fail if the object handle is invalid; a -1 is returned.
.TP 15
[WARNING - invalid or deleted object]
.SH SEE ALSO
DsInqClassId(3D)
