.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqClassId 3D "Dore"
.SH NAME
DsInqClassId \- Return the class identifier of a named class
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtInt DsInqClassId (class_name)
DtPtr class_name;
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DSQCI(CLSNME, N)
CHARACTER*N CLSNME
.in  -.5i
.fi 
.SH DESCRIPTION
.IX DSQCI
.IX DsInqClassId
.LP
\f2DsInqClassId\fP returns the class identifier of the class with the
string name \f2class_name\fP.  If \f2class_name\fP is not the name
of a class installed in Dore then \f2DsInqClassId\fP returns the
value -1. 
.LP
By convention, a class is given the same name as the C Language name
of the routine used to create an object of that class.  For example,
an object created with \f2DoPolygon\fP is of class ``DoPolygon''.
.SH FORTRAN SPECIFIC
.LP
The \f2CLSNME\fP parameter is the class name string, which is
\f2N\fP characters long.
