.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsExecutionAbort 3D  "Dore"
.SH NAME
DsExecutionAbort \- Abort traversal of the current method
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsExecutionAbort()
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSEA()
.in -.5i
.fi
.SH DESCRIPTION
.IX DSEA
.IX DsExecutionAbort
.I DsExecutionAbort
aborts traversal of the current method.
Callback objects may conditionally affect traversal of display or definition
hierarchies into which they are placed by calling \f2DsExecutionAbort\fP.
This causes the entire traversal to halt.
.PP
The traversal will halt only upon return from the callback function
that called \f2DsExecutionAbort\fP.
In other words, the callback function will be allowed to finish, but no other
objects will be executed after it in the same traversal.
.SH ERRORS
.I DsExecutionAbort
will fail if called outside of a traversal method;
the call to \f2DsExecutionAbort\fP will be ignored.
.TP 15
[WARNING - no traversal in progress]
.SH "SEE ALSO"
DoCallback(3D), DsExecuteObj(3D), DsExecutionReturn(3D)
