.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DpUpdVarQuadListUVW 3D  "Dore"
.SH NAME
DpUpdVarQuadListUVW \- Update the \f2uvw\fP texture coordinates of a variable quadrilateral list primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DpUpdVarQuadListUVW(object, 
		uvwindex, uvwlist)
DtObject object;
DtInt uvwindex;
DtReal uvwlist[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DPUQLW(OBJECT, UVWIDX, UVWLIST)
INTEGER*4 OBJECT
INTEGER*4 UVWIDX
REAL*8 UVWLIST(*)
.fi
.SH DESCRIPTION 
.IX DpUpdVarQuadListUVW
.IX DPUQLW
.I DpUpdVarQuadListUVW
updates one set of \f2uvw\fP texture coordinates of a 
variable quadrilateral list primitive object.
.PP
The parameter \f2object\fP is the handle to the variable
quadrilateral list object. 
.PP
The parameter \f2uvwindex\fP specifies which set of \f2uvw\fP 
coordinates is being updated.
Note that the \f2uvw\fP texture coordinates of a vertex are 
numbered from 0.
To \f2add\fP a new set of \f2uvw\fP coordinates to the vertex data
of an object, set the \f2uvwindex\fP to point to the next available
slot.
For example, for objects that do not have any \f2uvw\fP coordinates,
a \f2uvwindex\fP of 0 will create the initial set.
.PP
The parameter \f2uvwlist\fP contains the new \f2uvw\fP coordinates, one
for every vertex of the variable quadrilateral list object.
As with other variable vertex data, Dore
does not make a copy of the \f2uvw\fP coordinates.
It simply maintains pointers to the data in user space.
.SH ERRORS
.I DpUpdVarQuadListUVW
will fail if an invalid object is specified.
.TP 15
[WARNING - invalid or deleted object]
.PP
.I DpUpdVarQuadListUVW
will fail if \f2uvwindex\fP is less than 0 or greater than
the next available slot for \f2uvw\fP coordinates.
.TP 15
[WARNING - value out of range]
.SH "SEE ALSO"
DoVarQuadList(3D),
DpUpdVarQuadListUV(3D)
