.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoVarQuadGrid 3D  "Dore"
.SH NAME
DoVarQuadGrid \- Create a variable quadrilateral grid primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoVarQuadGrid(colormodel, width, height, vertlocs,
		vertnorms, vertcolors, smoothflag)
DtColorModel colormodel;
DtInt width, height;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
DtFlag smoothflag;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOVQDG(COLMOD, WIDTH, HEIGHT, VTXLOC, 
		VTXNRM, VTXCLR, SMOOFL)
INTEGER*4 COLMOD
INTEGER*4 WIDTH, HEIGHT
REAL*8 VTXLOC(*)
REAL*8 VTXNRM(*)
REAL*8 VTXCLR(*)
INTEGER*4 SMOOFL
.fi
.SH DESCRIPTION 
.IX DOVQDG
.IX DoVarQuadGrid
.I DoVarQuadGrid 
creates a primitive object that defines a variable
grid of (\f2width\fP-1) by (\f2height\fP-1) quadrilaterals.
.PP
The main difference between a variable quadrilateral grid and a quadrilateral 
grid is that the variable primitive does not make a copy of the 
vertex data into its own data space.  
It simply maintains pointers to the vertex data 
(locations, normals and colors) in user space.  
A call to \f2DpUpdVarQuadGrid\fP <\f2DPUVQG\fP>,
informs a variable quadrilateral grid object that the user data has changed.
.PP
The parameter \f2colormodel\fP specifies the color model used if 
vertex colors are provided.
The parameter \f2vertlocs\fP is an array of vertex locations.
Vertex data must be provided for \f2width*height\fP 
vertices.
Starting from the upper left corner,
the first \f2width\fP vertices specify the top edges of the grid.
Each subsequent group of \f2width\fP vertices specifies the
next row of vertices for the grid.
The parameter \f2vertnorms\fP is an array of vertex normals.
If vertex normals are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
The parameter \f2vertcolors\fP is an array of vertex colors. 
If vertex colors are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
.PP
If vertex normals are not provided, the parameter \f2smoothflag\fP
specifies that the vertex normal for shading
purposes will be the average of the geometric normals from a vertex's
adjacent surfaces.  This assumes that the quadrilateral grid defines a 
smooth surface.
.PP
The geometric normal to each quadrilateral is calculated using the right-hand rule
(when the fingers of the right hand point in the order of the vertices,
the thumb points in the direction of the normal).  
These normals are sometimes used for backface culling of
facet shading.
.PP
For texture mapping, \f2uv\fP and \f2uvw\fP vertex information is added
and modified using \f2DpUpdVarQuadGridUV\fP and \f2DpUpdVarQuadGridUVW\fP.
.PP
.SH ERRORS
.I DoVarQuadGrid
will issue a warning if a zero vertex normal is calculated by Dore.
.PP
[WARNING - quad normals sum to 0 at vertex, check for back to back triangles]
.SH "SEE ALSO"
.na
.nh
DpUpdVarQuadGrid(3D), DoQuadGrid(3D), DpUpdVarQuadGridUV(3D),
DpUpdVarQuadGridUVW(3D), DoQuadMesh(3D), DoQuadList(3D)
.ad
.hy
