.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoVarLineList 3D  "Dore"
.SH NAME
DoVarLineList \- Create a variable line list primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoVarLineList(colormodel, linecount, vertlocs, 
		vertnorms, vertcolors)
DtColorModel colormodel;
DtInt linecount;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOVLNL(COLMOD, LINCNT, VTXLOC, 
		VTXNRM, VTXCLR)
INTEGER*4 COLMOD
INTEGER*4 LINCNT
REAL*8 VTXLOC(*)
REAL*8 VTXNRM(*)
REAL*8 VTXCLR(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOVLNL
.IX DoVarLineList
.I DoVarLineList
creates a primitive object that defines a variable list of independent lines.
The main difference between a variable line list and a line list is
that the variable line list does not copy the vertex data into its
own data space.  
It simply maintains pointers to the vertex data (locations,
normals and colors) in user space.
A call to \f2DpUpdVarLineList\fP <\f2DPUVLL\fP> informs a variable
line list object that the user data has changed.
.PP
The parameter \f2colormodel\fP specifies the color model to be used when
defining vertex colors (if any).
The parameter \f2linecount\fP contains the number of lines in the list.
The parameter \f2vertlocs\fP is an array of three dimensional vertices
containing the locations of 2*\f2linecount\fP vertices.
The parameter \f2vertnorms\fP is an array of vertex normals.
If vertex normals are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
The parameter \f2vertcolors\fP is an array of vertex colors.
If vertex colors are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
.PP
If no vertex normals are provided, backface culling cannot affect for
lines because they have no surface
on which to define a geometric normal.
.SH "SEE ALSO"
.na
.nh
DpUpdVarLineList(3D), DoLineList(3D), DoVarPointList(3D),
DoVarTriangleMesh(3D), DoVarSimplePolygonMesh(3D),
DoVarTriangleStrip(3D)
.hy
.ad
