.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTranspIntens 3D  "Dore"
.SH NAME
DoTranspIntens \- Create a transparent intensity primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTranspIntens(intensity)
DtReal intensity;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTI(INTENS)
REAL*8 INTENS
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTI
.IX DoTranspIntens
\f2DoTranspIntens\fP creates a transparent intensity primitive attribute
object. 
The parameter \f2intensity\fP is
a weighting factor for the transparency of subsequent objects.
.PP
The value of \f2intensity\fP ranges between 0.0 and 1.0. 
A value of 0 corresponds to an opaque surface, while
a value of 1 means a surface is completely transparent.
.PP
The transparent intensity is one of several qualities
that make a surface transparent.
Other qualities include the transparent color
(set with \f2DoTranspColor <DOTC>\fP)
and the presence of transparency (set with \f2DoTranspSwitch <DOTS>\fP).
.SH DEFAULTS
The default \f2DoTranspIntens\fP is 0.5.
.SH "SEE ALSO"
.nh
.na
DoTranspColor(3D), DoTranspOrientColor(3D), DoTranspOrientExp(3D),
DoTranspOrientIntens(3D), DoTranspOrientSwitch(3D), DoTranspSwitch(3D)
.hy
.ad
