.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSimplePolygon 3D  "Dore"
.SH NAME
DoSimplePolygon \- Create a simple polygon primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSimplePolygon(colormodel, vertextype, 
	vertexcount, vertices, shape)
DtColorModel colormodel;
DtVertexType vertextype;
DtInt vertexcount;
DtReal vertices[\|];
DtShapeType shape;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOSPGN(COLMOD, VTXTYP, VTXCNT, 
	VTXS, SHAPE)
INTEGER*4 COLMOD
INTEGER*4 VTXTYP
INTEGER*4 VTXCNT
REAL*8 VTXS(*)
INTEGER*4 SHAPE
.in -.5i
.fi
.SH DESCRIPTION
.IX DOSPGN
.IX DoSimplePolygon
.I DoSimplePolygon
creates a primitive object that defines a simple polygon.  A simple
polygon is a planar collection of 
at least three vertices, forming a single
connected contour.  The contour may be either convex or
concave.
The boundaries of the contour may self-intersect.
.PP
The parameter \f2colormodel\fP specifies the color model used if the vertices
contain color information for shading purposes.  The parameter \f2vertextype\fP
specifies the exact nature of the vertices.  
for more information, refer to Chapter 6, \f2Dore Vertex Types\fP,
in the \f2Dore Reference Manual\fP or 
to the \f2VertexTypes\fP on-line manual page.)
.PP
The parameter \f2vertices\fP is an array of vertex data.
The parameter \f2vertexcount\fP specifies the number of vertices in the
simple polygon.  The parameter \f2vertices\fP is an array containing the
vertices, plus any other vertex data, in order.
.PP
The last vertex is automatically connected to the first.
.PP
The parameter \f2shape\fP hints at the geometry of the simple polygon.
Correctly specifying the shape of the contour will
result in optimal decomposition when necessary.
Incorrectly specifying the shape may result in an incorrect
or aborted decomposition.  The possible values for \f2shape\fP are:
.IP "\f2DcConvex\fP <\f2DCCNVX\fP>"
Path is wholly convex.
.IP "\f2DcConcave\fP <\f2DCCNCV\fP>"
Path may be concave but not self-intersecting.
.IP "\f2DcComplex\fP <\f2DCCPLX\fP>"
Path may be self-intersecting.
.PP
Geometric normals to the polygons in the mesh are calculated using the
right-hand rule (the fingers of the right hand point in the order of vertices
and the thumb points in the direction of the normal).
These normals are sometimes used for backface culling
and facet shading. 
Polygons are faceted if no vertex normals are provided and the smoothflag is
off.
.SH ERRORS
\f2DoSimplePolygon\fP must be called with a valid specification for 
\f2shape\fP.
.TP 15
[WARNING - invalid parameter]
.PP
\f2DoSimplePolygon\fP must be called with at least three vertices.
.TP 15
[WARNING - insufficient information]
.SH "SEE ALSO"
.na
.nh
DoPolygon(3D), DoPolygonMesh(3D), DoSimplePolygonMesh(3D),
VertexTypes(3D)
.hy
.ad
