.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSampleJitterSwitch 3D "Dore"
.SH NAME
DoSampleJitterSwitch \- Create a camera attribute object for enabling or disabling the use of jitter sampling for antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSampleJitterSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOSJSW(SWVAL)
INTEGER*4 SWVAL
.in  -.5i
.fi 
.IX "DoSampleJitterSwitch"
.IX "DOSJSW"
.SH DESCRIPTION
.LP
\f2DoSampleJitterSwitch\fP creates a jitter sampling switch camera 
attribute object for antialiasing.
.LP
Jitter sampling means that pixels are not sampled at a fixed point,
e.g. the pixel center, but at a random point within the pixel.
Jitter sampling can also be done in conjunction with supersampling.
.LP
The parameter \f2switchvalue\fP specifies whether subsequent cameras
can jitter sample the scene within each pixel.
.IX DcOn
.IX DCON
.IP "\f2DcOn\fP <\f2DCON\fP>"
Jitter sampling is enabled. 
.IX DcOff
.IX DCOFF
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
Each pixel will be sampled at a fixed point.
.SH DEFAULTS
The default \f2DoSampleJitterSwitch\fP is \f2DcOff\fP.
.SH SEE ALSO
.na
.nh
DoSampleJitter(3D),
DoSampleSuper(3D),
DoLocalAntiAliasStyle(3D),
DoLocalAntiAliasSwitch(3D)
.ad
.hy
\&
