.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSampleJitter 3D "Dore"
.SH NAME
DoSampleJitter \- Create a jitter sampling camera attribute object for antialiasing
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSampleJitter(factor)
DtReal factor;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOSJIT(FACTOR)
REAL*8 FACTOR
.in  -.5i
.fi 
.IX "DoSampleJitter"
.IX "DOSJIT"
.SH DESCRIPTION
.LP
\f2DoSampleJitter\fP creates a jitter sampling camera attribute 
object for antialiasing.
.LP
Jitter sampling means that pixels are not sampled at a fixed point,
e.g. the pixel center, but at a random point within the pixel.
Jitter sampling can also be done in conjunction with supersampling.
.LP
The parameter \f2factor\fP is a number 
specifying the percent of a pixel from the 
fixed point which is the maximum random deviation allowed.
Typically \f2factor\fP will be between \f20.0\fP and \f21.0\fP.
Adjusting this jitter factor gives control of the tradeoff between
decreased aliasing and increased noise.
.LP
Jitter sampling is enabled or
disabled with the \f2DoSampleJitterSwitch\fP
<\f2DOSJSW\fP> attribute.
.SH DEFAULTS
The default \f2DoSampleJitter\fP is 0.5.
.SH SEE ALSO
.na
DoSampleJitterSwitch(3D),
DoSampleSuper(3D),
DoLocalAntiAliasStyle(3D),
DoLocalAntiAliasSwitch(3D)
.ad
\&
