.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoRotate 3D  "Dore"
.SH NAME
DoRotate \- Create a rotation geometric transformation object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoRotate(axis, angle)
DtAxis axis;
DtReal angle;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOROT(AXIS, ANGLE)
INTEGER*4 AXIS
REAL*8 ANGLE
.in -.5i
.fi
.SH DESCRIPTION
.IX DOROT
.IX DoRotate
\f2DoRotate\fP creates a rotation geometric transformation object
that modifies the current transformation matrix attribute.
.PP
The parameter \f2axis\fP specifies the coordinate axis about which the rotation
is to take place.  Possible values are:
.in +.5i
.IP "\f2DcXAxis\fP <\f2DCXAX\fP>"
.IP "\f2DcYAxis\fP <\f2DCYAX\fP>"
.IP "\f2DcZAxis\fP <\f2DCZAX\fP>"
.in -.5i
.PP
The parameter \f2angle\fP specifies the angle of rotation.
It may take any positive or negative floating point value.
Positive rotations are determined by the right-hand rule; when looking down a
given axis from the direction of positive infinity towards the origin,
positive rotations are counterclockwise.
.PP
By default, \f2angle\fP is measured in radians. You can change the unit
of measure to degrees by using \f2DsSetAngleUnits <DSSAU>\fP
to set the angle units to \f2DcAngleDegrees\fP <\f2DCAD\fP>.
.SH "SEE ALSO"
.na
.nh
DoLookAtFrom(3D), DoScale(3D), DoShear(3D), DoTransformMatrix(3D),
DoTranslate(3D), DsInqAngleUnits(3D), DsSetAngleUnits(3D)
.hy
.ad
