.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPushMatrix 3D  "Dore"
.SH NAME
DoPushMatrix \- Create an organizational object that pushes the current transformation matrix 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPushMatrix()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPUMX()
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPUMX
.IX DoPushMatrix
.I DoPushMatrix
creates an organizational object that pushes 
the current transformation matrix.  This object
saves a local environment of geometric transformations; the environment is
restored by \f2DoPopMatrix\fP <\f2DOPPMX\fP>.
.PP
\f2DoPushMatrix\fP and \f2DoPopMatrix\fP <\f2DOPPMX\fP> act as a team to create a
local environment of geometric transformations that can be saved and restored.
\f2DoPushMatrix\fP pushes onto a local stack the
transformation matrix that
could be modified by objects 
between its location in the regular group and a subsequent
\f2DoPopMatrix\fP <\f2DOPPMX\fP> object.
.PP
Executing the \f2DoPopMatrix\fP object pops the transformation matrix
from the stack, thus restoring 
its earlier value.  
Therefore, any geometric transformations encountered between
the \f2DoPushMatrix\fP and \f2DoPopMatrix\fP objects are 
lost.
\f2DoPushMatrix\fP and \f2DoPopMatrix\fP group objects 
may be nested;
however, \f2DoPushMatrix\fP and \f2DoPopMatrix\fP 
will not work across
group boundaries.
.PP
During execution, regular groups act as if they performed a
\f2DoPushMatrix\fP before their execution starts and a
\f2DoPopMatrix\fP  <\f2DOPPMX\fP> when they are exited.
Inline groups behave differently; see \f2DoInLineGroup\fP.
When a group is closed, all \f2DoPushMatrix\fP objects still in effect
will be popped.
.PP
To perform a series of geometric transformations relative to an
absolute position, use \f2DoPushMatrix\fP before each set
of geometric transformations and \f2DoPopMatrix\fP afterward.  This
makes each set of geometric transformations relative to the original
starting position.
.PP
The transformation matrix attribute is also saved and restored with
\f2DoPushAtts\fP <\f2DOPUA\fP> and \f2DoPopAtts\fP <\f2DOPPA\fP>.
.SH "SEE ALSO"
.na
.nh
DoGroup(3D), DoInLineGroup(3D), DoPopAtts(3D), DoPushAtts(3D),
DoPopMatrix(3D)
.ad
.hy
