.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPolymarker 3D  "Dore"
.SH NAME
DoPolymarker \- Create a polymarker primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPolymarker(markercount, markerpositions)
DtInt markercount;
DtPoint3 markerpositions[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPM(MKRCNT, MKRPOS)
INTEGER*4 MKRCNT
REAL*8 MKRPOS(3,MKRCNT)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPM
.IX DoPolymarker
.I DoPolymarker
creates a polymarker primitive object.  A polymarker primitive
object is a set of markers, each having its own location.
The markers are rendered in a plane in frame space
that is parallel to the XY-plane of the device space.
The marker positions are individually transformed
into world coordinates using the current transformation
matrix. 
Then they are mapped into frame space using the current
camera projection matrix.
.PP
The locations of the markers are specified by an array of points. 
The parameter \f2markercount\fP specifies the number of points
in the array \f2markerpositions\fP. 
The parameter \f2markerpositions\fP is the two-dimensional array of
marker data.  The array will contain 3 real numbers for each marker.
.PP
A marker has no geometric size, so transformations will not affect the
displayed size of a marker.  A marker is drawn using a glyph that can be
specified using \f2DoMarkerGlyph\fP <\f2DOMG\fP> 
from a font that can be specified by
\f2DoMarkerFont\fP <\f2DOMF\fP>.  
The glyph can be scaled by a factor that can be set 
by \f2DoMarkerScale\fP <\f2DOMS\fP>.
.SH "SEE ALSO"
DoMarkerFont(3D), DoMarkerGlyph(3D), DoMarkerScale(3D)
