.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPickID 3D  "Dore"
.SH NAME
DoPickID \- Create a pick identifier object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPickID(pickid)
DtInt pickid;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPID(PICKID)
INTEGER*4 PICKID
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPID
.IX DoPickID
.I DoPickID
returns a pick identifier primitive attribute object. The argument \f2pickid\fP
determines the pick identification 
number for subsequent objects.
A pick identification number is an arbitrary 32-bit value 
that is used to identify various parts of the Dor\o.\(aae.  database.
It is similar to a name set in its ability to identify or give special meaning
to parts of the database.
.PP
The pick identifiers are part of the information returned in a pick.  They
are returned for the picked primitives as well as for their ancestors in the
hierarchy.
.SH DEFAULTS
The default \f2DoPickID\fP is 0.
.SH "SEE ALSO"
DdPickObjs(3D), DoNameSet(3D), DdSetPickCallback(3D)
