.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPerspective 3D  "Dore"
.SH NAME
DoPerspective \- Create a perspective studio attribute object for cameras
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPerspective(fov, hither, yon)
DtReal fov, hither, yon;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPER(FOV, HITHER, YON)
REAL*8 FOV, HITHER, YON
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPER
.IX DoPerspective
.I DoPerspective
creates a perspective studio attribute object for cameras.
.sp
The parameter \f2fov\fP specifies the frustum of vision angle (field
of view).  
By default, the frustum of vision is measured in degrees.
You can change the unit of measure to radians
by setting \f2DsSetAngleUnits <DSSAU>\fP to
\f2DcAngleRadians <DCAR>\fP.
.sp
The parameters \f2hither\fP and \f2yon\fP
specify the location of the front and the back clipping planes
in camera coordinates.
Note that both of these planes must be ahead of the camera.
Because the camera's location in its own relative
coordinate system is always at (0.0, 0.0, 0.0) looking down the negative
Z-axis, both \f2hither\fP and \f2yon\fP must be negative.
.SH ERRORS
.I DoPerspective
will fail if \f2hither\fP is less than or equal to \f2yon\fP.
.TP 15
[WARNING - value out of range]
.PP
.I DoPerspective
will fail if \f2hither\fP is greater than or equal to 0.0.
.TP 15
[WARNING - value out of range]
.SH "SEE ALSO"
.na
.nh
DoCamera(3D),
DoCameraMatrix(3D), 
DoParallel(3D), 
DoProjection(3D), 
DsInqAngleUnits(3D),
DsSetAngleUnits(3D)
.ad
.hy
