.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoNameSet 3D  "Dore"
.SH NAME
DoNameSet \- Create a name set modifying object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoNameSet(n, members, setop)
DtInt n;
DtInt members[\|];
DtSetOperation setop;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DONS(N, MEMBER, SETOP)
INTEGER*4 N
INTEGER*4 MEMBER(N)
INTEGER*4 SETOP
.in -.5i
.fi
.SH DESCRIPTION
.IX DONS
.IX DoNameSet
.I DoNameSet
creates an organizational object for modifying name set attributes.
Name set attributes, in conjunction with filter attributes,
provide a high-level control over invisibility and
pickability.  See \f2DoFilter\fP for details. 
.PP
The parameter \f2members\fP is a list of members of the specified name set to be
affected.  \f2n\fP is the number of elements in the list.
The argument \f2setop\fP
specifies how the status of the members referred to in \f2members\fP
is to be affected. The valid choices for \f2setop\fP are:
.IP "\f2DcSetAdd\fP \f2<DCSADD>\fP"
Adds the members listed in \f2members\fP to the current name set.
.IP "\f2DcSetDelete\fP \f2<DCSDEL>\fP"
Removes the members listed in \f2members\fP from the current name set.
.IP "\f2DcSetInvert\fP \f2<DCSINV>\fP"
Causes all members of the name set listed in \f2members\fP to take
on the opposite of their current values.  In other words, if the given
set members are not in the current name set, they will be added;
if they are included, they will be removed.
.IP "\f2DcSetReplace\fP \f2<DCSREP>\fP"
Replaces the current value of the specified name set with one
that includes only the members listed in \f2members\fP.
.SH ERRORS
.I DoNameSet
will fail if an invalid \f2setop\fP value is specified.
.TP 15
[FATAL - invalid set operation]
.SH DEFAULTS
The default name set is empty.
.SH "SEE ALSO"
DoFilter(3D), DoInvisSwitch(3D), DoPickSwitch(3D)
