.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoMarkerGlyph 3D  "Dore"
.SH NAME
DoMarkerGlyph \- Create a marker glyph primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoMarkerGlyph(glyph)
DtInt glyph;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOMG(GLYPH)
INTEGER*4 GLYPH
.in -.5i
.fi
.SH DESCRIPTION
.IX DOMG
.IX DoMarkerGlyph
.I DoMarkerGlyph
creates a marker glyph primitive attribute object.
The parameter \f2glyph\fP specifies the marker glyph for all following
polymarker primitive objects.  A marker glyph is an index into the
marker font.
.PP
There is a special glyph that can be reached from any marker font
using the index \f2DcMarkerPoint\fP <\f2DCMKPT\fP>.  This glyph
always represents itself as a single pixel on the screen, independent of
marker scaling.
.PP
In C, you can access a glyph in a font by typecasting:
.sp
          DoMarkerGlyph((DtInt)'*')
.sp
.SH DEFAULTS
The default \f2DoMarkerGlyph\fP is \f2DcMarkerPoint\fP <\f2DCMKPT\fP>.
.SH "SEE ALSO"
DoMarkerFont(3D), DoMarkerScale(3D), DoPolymarker(3D)
