.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLineType 3D  "Dore"
.SH NAME
DoLineType \- Create a line type primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLineType(type)
DtLineType type;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOLNT(TYPE)
INTEGER*4 TYPE
.in -.5i
.fi
.SH DESCRIPTION
.IX DOLNT
.IX DoLineType
\f2DoLineType\fP creates a line type primitive attribute object.
This object causes all subsequent primitive objects defined as lines, curves,
or combinations of the two to be drawn with the appropriate line type.
Possible values for \f2type\fP are:
.IP "\f2DcLineTypeSolid\fP <\f2DCLTS\fP>"
Solid
.IP "\f2DcLineTypeDash\fP <\f2DCLTDS\fP>"
Dashed
.IP "\f2DcLineTypeDot\fP <\f2DCLTDT\fP>"
Dotted
.IP "\f2DcLineTypeDotDash\fP <\f2DCLTDD\fP>"
Dot and dash repeated
.SH DEFAULTS
The default \f2DoLineType\fP is \f2DcLineTypeSolid\fP <\f2DCLTS\fP>.
.SH "SEE ALSO"
DoLineList(3D), DoLineWidth(3D), DoPolyline(3D)
