.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoInvisSwitch 3D  "Dore"
.SH NAME
DoInvisSwitch \- Create a primitive attribute object for enabling or disabling the invisibility of primitive objects. 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoInvisSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOINVS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOINVS
.IX DoInvisSwitch
.I DoInvisSwitch
creates an invisibility switch primitive attribute object. 
The parameter
\f2switchvalue\fP determines whether subsequent primitive
objects will be rendered.  The parameter takes one of the following values:
.IP "\f2DcOff\fP <\f2DCOFF\fP>"
Render subsequent primitive objects normally.
.IP "\f2DcOn\fP <\f2DCON\fP>"
Do not render subsequent primitive objects.
.PP
\f2DoInvisSwitch\fP provides direct control of the invisibility
primitive attribute at the lowest level.  Higher level control is provided
through name sets and filters.
.SH DEFAULTS
The default value for \f2DoInvisSwitch\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH "SEE ALSO"
DoFilter(3D), DoNameSet(3D) 
