.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoGroup 3D  "Dore"
.SH NAME
DoGroup \- Create a group organizational object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoGroup(open)
DtFlag open;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOG(OPEN)
INTEGER*4 OPEN
.in -.5i
.fi
.SH DESCRIPTION
.IX DOG
.IX DoGroup
.I DoGroup
creates a new group organizational object.
A group is an organizational object that contains other objects called
the elements of the group.
A group can be thought of as a simple list.
The parameter \f2open\fP determines whether the group is created open, i.e.,
whether the group is available for edit.
Groups are edited using the following functions:
\f2DgAddObj\fP <\f2DGAO\fP>, \f2DgAddObjToGroup\fP <\f2DGAOG\fP>,
\f2DgReplaceObj\fP <\f2DGRO\fP>,
\f2DgReplaceObjInGroup\fP <\f2DGROG\fP>,
\f2DgDelEleBetweenLabels\fP <\f2DGDEL\fP>, \f2DgDelEle\fP <\f2DGDE\fP>,
and \f2DgDelEleRange\fP <\f2DGDER\fP>.
An existing group can be opened with \f2DgOpen\fP <\f2DGO\fP>.
.PP
An element pointer is used by many of the editing
functions to designate the element(s) to be edited.
There is one element pointer per group, and it remembers its last location.
Label objects also may be used within the group to identify key objects
for some editing functions  (see \f2DoLabel\fP).
The application should close a group when it has
finished editing the group
(see \f2DgClose\fP).
.PP
Groups can contain other groups, allowing an
application to construct hierarchies of groups to
match the hierarchical structure of the application model.
A single group may be a child group of more than one group; i.e.,
the same group may be instanced in several places.
Each time the group is instanced, it inherits the current attributes wherever
it is instanced.
.PP
When one group references another group, the referenced group starts
with a complete set of the current appearance and geometric attributes
of the referencing group.  The referenced group may add its own
geometric transformations or appearance attributes for its own
primitive objects and then pass the new set of attributes on to any groups
it references.
.PP
There are two kinds of groups, regular groups and inline groups; these differ
only in the way they inherit attributes.
.PP
In a regular group, a copy of all attributes is saved
upon entering the group and restored
when execution of the group terminates.
This pushing and popping of attributes directs inheritance in one direction 
only; attributes changed within a referenced group do not affect the 
attributes of the referencing group.
.PP
Inline groups, created with \f2DoInLineGroup\fP <\f2DOILG\fP>, are slightly
different. They do not push and pop the current
attributes upon entry and exit.  Changes made to attributes
by an inline group have the same effect as if they had been placed
directly in the calling group.  The inline group thus provides a
mechanism for defining a commonly used set of attributes once and
.PP
A group network consists of a group and all the groups referenced,
either directly or indirectly, by that group.
Group networks can be very complex; nothing prevents them from including
arbitrary cyclic or recursive references.
These recursive references are not supported and should be avoided
by the application because they cause unpredictable 
and often fatal results
(see \f2DgCheck\fP).
then using the set multiple times.
.SH "SEE ALSO"
.na
.nh
DgAddObj(3D), DgAddObjToGroup(3D), DgCheck(3D), DgClose(3D),
DgDelEle(3D), DgDelEleBetweenLabels(3D), DgDelEleRange(3D), DgEmpty(3D),
DgInqElePtr(3D), DgInqSize(3D), DgInqObjAtPos(3D), DgInqOpen(3D),
DgOpen(3D), DgReplaceObj(3D), DgSetElePtr(3D), DgSetElePtrRelLabel(3D),
DoInLineGroup(3D), DoLabel(3D)
.ad
.hy
