.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgReplaceObj 3D  "Dore"
.SH NAME
DgReplaceObj \- Replace an object in the currently open group
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DgReplaceObj(object)
DtObject object;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DGRO(OBJECT)
INTEGER*4 OBJECT
.in -.5i
.fi
.SH DESCRIPTION
.IX DGRO
.IX DgReplaceObj
\f2DgReplaceObj\fP places the object, \f2object\fP, in the currently
open group.
If the group's element pointer is not at the end of the
group, the object \f2replaces\fP the object immediately following
the group's element pointer. 
If the group's element pointer is after the last
element in the group, the object is \f2appended\fP to the end of the
group.  In both cases, the group element pointer remains pointing at
the object just replaced or inserted; i.e., the element pointer never
moves.
.PP
The most common way to call the \f2DgReplaceObj\fP function is:
.nf

	DgReplaceObj(DoXXXX());

.fi
where the \f2DoXXXX()\fP call creates and returns an object of type
XXXX, and this object is added to the currently open 
group through the
\f2DgReplaceObj\fP call.  One can also create an object through
a separate call to a \f2DoXXXX\fP routine and then call the
\f2DgReplaceObj\fP routine with the object directly:
.nf

	object = DoXXXX();
	DsHoldObj(object);
	DgReplaceObj(object);

.fi
One may also call this function in the following manner:
.nf

	DgReplaceObj(DsHoldObj(object=DoXXXX()));

.fi
This will place the handle of the newly created object
in \f2object\fP and place the object in the currently open
group.
.PP
The call to \f2DsHoldObj\fP <\f2DSHO\fP> is needed only if 
the user also wants to
use the object created for other purposes.  Note that any object held with a
\f2DsHoldObj\fP <\f2DSHO\fP> will not be deleted.
The application program is always responsible for 
reclaiming storage
from held objects that are no longer needed.
.SH ERRORS
.I DgReplaceObj
will fail if passed an invalid object.
.TP 15
[WARNING - invalid or deleted object]
.PP
.I DgReplaceObj
will fail if no group is currently open.
.TP 15
[WARNING - a group is not currently open]
.SH "SEE ALSO"
.na
.nh
DgAddObjToGroup(3D), DgInqOpen(3D), DgOpen(3D), DoGroup(3D),
DoInLineGroup(3D), DsHoldObj(3D)
.ad
.hy
