.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgDelEleRange 3D  "Dore"
.SH NAME
DgDelEleRange \- Remove a range of elements from the currently open group
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DgDelEleRange(from, to)
DtInt from;
DtInt to;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DGDER(FROM, TO)
INTEGER*4 FROM
INTEGER*4 TO
.in -.5i
.fi
.SH DESCRIPTION
.IX DGDER
.IX DgDelEleRange
.I DgDelEleRange
deletes a range of elements between the specified locations, \f2from\fP and
\f2to\fP, from the currently open group.
If the \f2from\fP location is
negative, elements will be deleted starting at the beginning of the group.
If the \f2to\fP location is past the end of the group, elements will be
deleted only to the end of the group.
The element pointer will point to the element after the last one
that was deleted.
.SH ERRORS
.I DgDelEleRange
will fail if no group is currently open.
.TP 15
[WARNING - a group is not currently open]
.SH "SEE ALSO"
DgDelEle(3D), DgDelEleBetweenLabels(3D), DgEmpty(3D)
