.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgClose 3D  "Dore"
.SH NAME
DgClose \- Close a group object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DgClose()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DGCS()
.in -.5i
.fi
.SH DESCRIPTION
.IX DGCS
.IX DgClose
.I DgClose
closes the currently open group and returns its object handle.
If no group is currently open, then \f2DcNullObject\fP <\f2DCNULL\fP> is
returned.
Open groups may be nested in Dore.  If there are nested open groups,
\f2DgClose\fP closes only the most recently opened group (also known as the
active group).  Only one group is active at any one time.
Groups are opened with \f2DgOpen\fP <\f2DGO\fP> or created open using the
appropriate arguments to \f2DoGroup\fP <\f2DOG\fP>.
.SH "SEE ALSO"
DgInqOpen(3D), DgOpen(3D), DoGroup(3D), DoInLineGroup(3D)
