.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DfSetBoundary 3D  "Dore"
.SH NAME
DfSetBoundary \- Set the frame boundary
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DfSetBoundary(frame, boundary)
DtObject frame;
DtVolume *boundary;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DFSB(FRAME, BNDRY)
INTEGER*4 FRAME
REAL*8 BNDRY(6)
.in -.5i
.fi
.SH DESCRIPTION
.IX DFSB
.IX DfSetBoundary
.I DfSetBoundary
sets the boundary of a specified frame, \f2frame\fP, 
to the volume specified in \f2boundary\fP.
A frame defines
a device-independent 3D local coordinate system within which one
or more views can be positioned.  The frame boundary can be queried
using \f2DfInqBoundary\fP <\f2DFQB\fP>.
.PP
The frame is mapped onto the largest right rectangular volume that can fit
within the device viewport such that aspect ratio in X and Y is preserved and
that the Z extent of the frame is mapped to the entire Z extent of the device.
When this mapping is performed, there may be extra "white space"
inside the device viewport.  The function \f2DfSetJust\fP <\f2DFSJ\fP>
can be used to position this white space.
.SH ERRORS
.I DfSetBoundary
will fail if the frame handle is invalid.
.TP 15
[WARNING - invalid frame handle]
.SH DEFAULTS
The default frame boundary extends from (0.0, 0.0, 0.0) to
(1.0, 1.0, 1.0).
.SH "SEE ALSO"
.na
.nh
DdSetFrame(3D), DfInqBoundary(3D), DfSetJust(3D), DfUpdate(3D)
.ad
.hy
