.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DeDeleteObject 3D "Dore"
.SH NAME
DeDeleteObject \- Delete an internal Dore object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DeDeleteObject(object)
DtObject object;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DEDO(OBJECT)
INTEGER*4 OBJECT
.fi 
.SH DESCRIPTION
.IX DEDO
.IX DeDeleteObject
.LP
\f2DeDeleteObject\fP deletes the Dore object, \f2object\fP, if it is not 
referenced by other objects, and if the user has not placed a hold on the
object with \f2DsHoldObj()\fP <\f2DSHO\fP>. It is used
by implementations of user-defined classes.
.SH ERRORS
.I DeDeleteObject
will fail if the object handle is invalid.
.TP 15
[WARNING - invalid or deleted object]
.SH SEE ALSO
DsHoldObj(3D), DsReleaseObj(3D)
